/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>GetOpenIdTokenForDeveloperIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpenIdTokenForDeveloperIdentityRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<GetOpenIdTokenForDeveloperIdentityRequest.Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOpenIdTokenForDeveloperIdentityRequest::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOpenIdTokenForDeveloperIdentityRequest::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<Map<String, String>> LOGINS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetOpenIdTokenForDeveloperIdentityRequest::logins))
            .setter(setter(Builder::logins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logins").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> TOKEN_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetOpenIdTokenForDeveloperIdentityRequest::tokenDuration)).setter(setter(Builder::tokenDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_ID_FIELD, LOGINS_FIELD, TOKEN_DURATION_FIELD));

    private final String identityPoolId;

    private final String identityId;

    private final Map<String, String> logins;

    private final Long tokenDuration;

    private GetOpenIdTokenForDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.tokenDuration = builder.tokenDuration;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair represents a
     * user from a public provider or developer provider. If the user is from a developer provider, the name-value pair
     * will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>. The developer
     * provider is the "domain" by which Cognito will refer to your users; you provided this domain while
     * creating/updating the identity pool. The developer user identifier is an identifier from your backend that
     * uniquely identifies a user. When you create an identity pool, you can specify the supported logins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair
     *         represents a user from a public provider or developer provider. If the user is from a developer provider,
     *         the name-value pair will follow the syntax
     *         <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the
     *         "domain" by which Cognito will refer to your users; you provided this domain while creating/updating the
     *         identity pool. The developer user identifier is an identifier from your backend that uniquely identifies
     *         a user. When you create an identity pool, you can specify the supported logins.
     */
    public Map<String, String> logins() {
        return logins;
    }

    /**
     * <p>
     * The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that you
     * can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can exchange the
     * token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour. The maximum token
     * duration you can set is 24 hours. You should take care in setting the expiration time for a token, as there are
     * significant security implications: an attacker could use a leaked token to access your AWS resources for the
     * token's duration.
     * </p>
     * 
     * @return The expiration time of the token, in seconds. You can specify a custom expiration time for the token so
     *         that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You
     *         can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of
     *         one hour. The maximum token duration you can set is 24 hours. You should take care in setting the
     *         expiration time for a token, as there are significant security implications: an attacker could use a
     *         leaked token to access your AWS resources for the token's duration.
     */
    public Long tokenDuration() {
        return tokenDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(logins());
        hashCode = 31 * hashCode + Objects.hashCode(tokenDuration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdTokenForDeveloperIdentityRequest)) {
            return false;
        }
        GetOpenIdTokenForDeveloperIdentityRequest other = (GetOpenIdTokenForDeveloperIdentityRequest) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(identityId(), other.identityId())
                && Objects.equals(logins(), other.logins()) && Objects.equals(tokenDuration(), other.tokenDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOpenIdTokenForDeveloperIdentityRequest").add("IdentityPoolId", identityPoolId())
                .add("IdentityId", identityId()).add("Logins", logins()).add("TokenDuration", tokenDuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "Logins":
            return Optional.ofNullable(clazz.cast(logins()));
        case "TokenDuration":
            return Optional.ofNullable(clazz.cast(tokenDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpenIdTokenForDeveloperIdentityRequest, T> g) {
        return obj -> g.apply((GetOpenIdTokenForDeveloperIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOpenIdTokenForDeveloperIdentityRequest> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair
         * represents a user from a public provider or developer provider. If the user is from a developer provider, the
         * name-value pair will follow the syntax <code>"developer_provider_name": "developer_user_identifier"</code>.
         * The developer provider is the "domain" by which Cognito will refer to your users; you provided this domain
         * while creating/updating the identity pool. The developer user identifier is an identifier from your backend
         * that uniquely identifies a user. When you create an identity pool, you can specify the supported logins.
         * </p>
         * 
         * @param logins
         *        A set of optional name-value pairs that map provider names to provider tokens. Each name-value pair
         *        represents a user from a public provider or developer provider. If the user is from a developer
         *        provider, the name-value pair will follow the syntax
         *        <code>"developer_provider_name": "developer_user_identifier"</code>. The developer provider is the
         *        "domain" by which Cognito will refer to your users; you provided this domain while creating/updating
         *        the identity pool. The developer user identifier is an identifier from your backend that uniquely
         *        identifies a user. When you create an identity pool, you can specify the supported logins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logins(Map<String, String> logins);

        /**
         * <p>
         * The expiration time of the token, in seconds. You can specify a custom expiration time for the token so that
         * you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes. You can
         * exchange the token with Amazon STS for temporary AWS credentials, which are valid for a maximum of one hour.
         * The maximum token duration you can set is 24 hours. You should take care in setting the expiration time for a
         * token, as there are significant security implications: an attacker could use a leaked token to access your
         * AWS resources for the token's duration.
         * </p>
         * 
         * @param tokenDuration
         *        The expiration time of the token, in seconds. You can specify a custom expiration time for the token
         *        so that you can cache it. If you don't provide an expiration time, the token is valid for 15 minutes.
         *        You can exchange the token with Amazon STS for temporary AWS credentials, which are valid for a
         *        maximum of one hour. The maximum token duration you can set is 24 hours. You should take care in
         *        setting the expiration time for a token, as there are significant security implications: an attacker
         *        could use a leaked token to access your AWS resources for the token's duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenDuration(Long tokenDuration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityId;

        private Map<String, String> logins = DefaultSdkAutoConstructMap.getInstance();

        private Long tokenDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdTokenForDeveloperIdentityRequest model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityId(model.identityId);
            logins(model.logins);
            tokenDuration(model.tokenDuration);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Map<String, String> getLogins() {
            return logins;
        }

        @Override
        public final Builder logins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
            return this;
        }

        public final void setLogins(Map<String, String> logins) {
            this.logins = LoginsMapCopier.copy(logins);
        }

        public final Long getTokenDuration() {
            return tokenDuration;
        }

        @Override
        public final Builder tokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
            return this;
        }

        public final void setTokenDuration(Long tokenDuration) {
            this.tokenDuration = tokenDuration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOpenIdTokenForDeveloperIdentityRequest build() {
            return new GetOpenIdTokenForDeveloperIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
