/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolResponseUnmarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CognitoIdentityProviderAsyncClient}.
 *
 * @see CognitoIdentityProviderAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCognitoIdentityProviderAsyncClient implements CognitoIdentityProviderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCognitoIdentityProviderAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultCognitoIdentityProviderAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = init(false);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            AddCustomAttributesRequest addCustomAttributesRequest) {
        try {

            HttpResponseHandler<AddCustomAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AddCustomAttributesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AddCustomAttributesRequest, AddCustomAttributesResponse>()
                    .withMarshaller(new AddCustomAttributesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(addCustomAttributesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminAddUserToGroupRequest
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            AdminAddUserToGroupRequest adminAddUserToGroupRequest) {
        try {

            HttpResponseHandler<AdminAddUserToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminAddUserToGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminAddUserToGroupRequest, AdminAddUserToGroupResponse>()
                    .withMarshaller(new AdminAddUserToGroupRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(adminAddUserToGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        Represents the request to confirm user registration.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) {
        try {

            HttpResponseHandler<AdminConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminConfirmSignUpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminConfirmSignUpRequest, AdminConfirmSignUpResponse>()
                    .withMarshaller(new AdminConfirmSignUpRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(adminConfirmSignUpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new user in the specified user pool and sends a welcome message via email or phone (SMS). This message
     * is based on a template that you configured in your call to <a href="API_CreateUserPool.html">CreateUserPool</a>
     * or <a href="API_UpdateUserPool.html">UpdateUserPool</a>. This template includes your custom sign-up instructions
     * and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminCreateUserRequest
     *        Represents the request to create a user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminCreateUserResponse> adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) {
        try {

            HttpResponseHandler<AdminCreateUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminCreateUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminCreateUserRequest, AdminCreateUserResponse>()
                    .withMarshaller(new AdminCreateUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminCreateUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) {
        try {

            HttpResponseHandler<AdminDeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminDeleteUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminDeleteUserRequest, AdminDeleteUserResponse>()
                    .withMarshaller(new AdminDeleteUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminDeleteUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        try {

            HttpResponseHandler<AdminDeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminDeleteUserAttributesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResponse>()
                            .withMarshaller(new AdminDeleteUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminDeleteUserAttributesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to
     * disable is a Cognito User Pools native username + password user, they are not permitted to use their password to
     * sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is
     * removed. The next time the external user (no longer attached to the previously linked
     * <code>DestinationUser</code>) signs in, they must create a new user account. See <a
     * href="API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a>.
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the
     * <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers.
     * The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was
     * originally linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked in the <a
     * href="API_AdminLinkProviderForUser.html">AdminLinkProviderForUser</a> call. (If the linking was done with
     * <code>ProviderAttributeName</code> set to <code>Cognito_Subject</code>, the same applies here). However, if the
     * user has already signed in, the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and
     * <code>ProviderAttributeValue</code> must be the subject of the SAML assertion.
     * </p>
     *
     * @param adminDisableProviderForUserRequest
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        try {

            HttpResponseHandler<AdminDisableProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminDisableProviderForUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminDisableProviderForUserRequest, AdminDisableProviderForUserResponse>()
                            .withMarshaller(new AdminDisableProviderForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminDisableProviderForUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable any user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDisableUserResponse> adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) {
        try {

            HttpResponseHandler<AdminDisableUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminDisableUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminDisableUserRequest, AdminDisableUserResponse>()
                    .withMarshaller(new AdminDisableUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminDisableUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminEnableUserResponse> adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) {
        try {

            HttpResponseHandler<AdminEnableUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminEnableUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminEnableUserRequest, AdminEnableUserResponse>()
                    .withMarshaller(new AdminEnableUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminEnableUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        try {

            HttpResponseHandler<AdminForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminForgetDeviceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminForgetDeviceRequest, AdminForgetDeviceResponse>()
                    .withMarshaller(new AdminForgetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminForgetDeviceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AdminGetDeviceResponse> adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) {
        try {

            HttpResponseHandler<AdminGetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminGetDeviceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminGetDeviceRequest, AdminGetDeviceResponse>()
                    .withMarshaller(new AdminGetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminGetDeviceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AdminGetUserResponse> adminGetUser(AdminGetUserRequest adminGetUserRequest) {
        try {

            HttpResponseHandler<AdminGetUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminGetUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminGetUserRequest, AdminGetUserResponse>()
                    .withMarshaller(new AdminGetUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminGetUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        try {

            HttpResponseHandler<AdminInitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminInitiateAuthResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminInitiateAuthRequest, AdminInitiateAuthResponse>()
                    .withMarshaller(new AdminInitiateAuthRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminInitiateAuthRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external
     * identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external
     * identity provider. This allows you to create a link from the existing user account to an external federated user
     * identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the
     * existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity, so that when the federated user identity is used, the user signs in as the existing user account.
     * </p>
     * <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external identity providers and provider attributes that have been
     * trusted by the application owner.
     * </p>
     * </important>
     * <p>
     * See also <a href="API_AdminDisableProviderForUser.html">AdminDisableProviderForUser</a>.
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     *
     * @param adminLinkProviderForUserRequest
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) {
        try {

            HttpResponseHandler<AdminLinkProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminLinkProviderForUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminLinkProviderForUserRequest, AdminLinkProviderForUserResponse>()
                            .withMarshaller(new AdminLinkProviderForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminLinkProviderForUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListDevicesResponse> adminListDevices(AdminListDevicesRequest adminListDevicesRequest) {
        try {

            HttpResponseHandler<AdminListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminListDevicesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminListDevicesRequest, AdminListDevicesResponse>()
                    .withMarshaller(new AdminListDevicesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(adminListDevicesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminListGroupsForUserRequest
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        try {

            HttpResponseHandler<AdminListGroupsForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminListGroupsForUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminListGroupsForUserRequest, AdminListGroupsForUserResponse>()
                            .withMarshaller(new AdminListGroupsForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminListGroupsForUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) {
        try {

            HttpResponseHandler<AdminRemoveUserFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminRemoveUserFromGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminRemoveUserFromGroupRequest, AdminRemoveUserFromGroupResponse>()
                            .withMarshaller(new AdminRemoveUserFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminRemoveUserFromGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to
     * sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should
     * direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition,
     * if the user pool has phone verification selected and a verified phone number exists for the user, or if email
     * verification is selected and a verified email exists for the user, calling this API will also result in sending a
     * message to the end user with the code to change their password.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        try {

            HttpResponseHandler<AdminResetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminResetUserPasswordResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminResetUserPasswordRequest, AdminResetUserPasswordResponse>()
                            .withMarshaller(new AdminResetUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminResetUserPasswordRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Responds to an authentication challenge, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        try {

            HttpResponseHandler<AdminRespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminRespondToAuthChallengeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminRespondToAuthChallengeRequest, AdminRespondToAuthChallengeResponse>()
                            .withMarshaller(new AdminRespondToAuthChallengeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminRespondToAuthChallengeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets all the user settings for a specified user name. Works on any user.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminSetUserSettingsRequest
     *        Represents the request to set user settings as an administrator.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        try {

            HttpResponseHandler<AdminSetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminSetUserSettingsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<AdminSetUserSettingsRequest, AdminSetUserSettingsResponse>()
                    .withMarshaller(new AdminSetUserSettingsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(adminSetUserSettingsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        try {

            HttpResponseHandler<AdminUpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminUpdateDeviceStatusResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateDeviceStatusRequest, AdminUpdateDeviceStatusResponse>()
                            .withMarshaller(new AdminUpdateDeviceStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminUpdateDeviceStatusRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        try {

            HttpResponseHandler<AdminUpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminUpdateUserAttributesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResponse>()
                            .withMarshaller(new AdminUpdateUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminUpdateUserAttributesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Signs out users from all devices, as an administrator.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) {
        try {

            HttpResponseHandler<AdminUserGlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new AdminUserGlobalSignOutResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<AdminUserGlobalSignOutRequest, AdminUserGlobalSignOutResponse>()
                            .withMarshaller(new AdminUserGlobalSignOutRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(adminUserGlobalSignOutRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        try {

            HttpResponseHandler<ChangePasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ChangePasswordResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ChangePasswordRequest, ChangePasswordResponse>()
                    .withMarshaller(new ChangePasswordRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(changePasswordRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     * </p>
     *
     * @param confirmDeviceRequest
     *        Confirms the device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmDeviceResponse> confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) {
        try {

            HttpResponseHandler<ConfirmDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ConfirmDeviceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ConfirmDeviceRequest, ConfirmDeviceResponse>()
                    .withMarshaller(new ConfirmDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(confirmDeviceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        try {

            HttpResponseHandler<ConfirmForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ConfirmForgotPasswordResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResponse>()
                    .withMarshaller(new ConfirmForgotPasswordRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(confirmForgotPasswordRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms registration of a user and handles the existing alias from a previous user.
     * </p>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action (e.g., sign in).</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmSignUpResponse> confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) {
        try {

            HttpResponseHandler<ConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ConfirmSignUpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ConfirmSignUpRequest, ConfirmSignUpResponse>()
                    .withMarshaller(new ConfirmSignUpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(confirmSignUpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        try {

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an identity provider for a user pool.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        try {

            HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateIdentityProviderResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createIdentityProviderRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes in it.
     * </p>
     *
     * @param createResourceServerRequest
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceServerResponse> createResourceServer(
            CreateResourceServerRequest createResourceServerRequest) {
        try {

            HttpResponseHandler<CreateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateResourceServerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateResourceServerRequest, CreateResourceServerResponse>()
                    .withMarshaller(new CreateResourceServerRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createResourceServerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the user import job.
     * </p>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            CreateUserImportJobRequest createUserImportJobRequest) {
        try {

            HttpResponseHandler<CreateUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateUserImportJobResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateUserImportJobRequest, CreateUserImportJobResponse>()
                    .withMarshaller(new CreateUserImportJobRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createUserImportJobRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolResponse> createUserPool(CreateUserPoolRequest createUserPoolRequest) {
        try {

            HttpResponseHandler<CreateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateUserPoolResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateUserPoolRequest, CreateUserPoolResponse>()
                    .withMarshaller(new CreateUserPoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUserPoolRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope does not exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            CreateUserPoolClientRequest createUserPoolClientRequest) {
        try {

            HttpResponseHandler<CreateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateUserPoolClientResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateUserPoolClientRequest, CreateUserPoolClientResponse>()
                    .withMarshaller(new CreateUserPoolClientRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createUserPoolClientRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     *
     * @param createUserPoolDomainRequest
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            CreateUserPoolDomainRequest createUserPoolDomainRequest) {
        try {

            HttpResponseHandler<CreateUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new CreateUserPoolDomainResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<CreateUserPoolDomainRequest, CreateUserPoolDomainResponse>()
                    .withMarshaller(new CreateUserPoolDomainRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createUserPoolDomainRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group. Currently only groups with no members can be deleted.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        try {

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an identity provider for a user pool.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier is not
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        try {

            HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteIdentityProviderResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteIdentityProviderRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     *
     * @param deleteResourceServerRequest
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            DeleteResourceServerRequest deleteResourceServerRequest) {
        try {

            HttpResponseHandler<DeleteResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteResourceServerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteResourceServerRequest, DeleteResourceServerResponse>()
                    .withMarshaller(new DeleteResourceServerRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteResourceServerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a user to delete himself or herself.
     * </p>
     *
     * @param deleteUserRequest
     *        Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        try {

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                    .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     *
     * @param deleteUserAttributesRequest
     *        Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            DeleteUserAttributesRequest deleteUserAttributesRequest) {
        try {

            HttpResponseHandler<DeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteUserAttributesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteUserAttributesRequest, DeleteUserAttributesResponse>()
                    .withMarshaller(new DeleteUserAttributesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteUserAttributesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     *
     * @param deleteUserPoolRequest
     *        Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolResponse> deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) {
        try {

            HttpResponseHandler<DeleteUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteUserPoolResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteUserPoolRequest, DeleteUserPoolResponse>()
                    .withMarshaller(new DeleteUserPoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserPoolRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            DeleteUserPoolClientRequest deleteUserPoolClientRequest) {
        try {

            HttpResponseHandler<DeleteUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteUserPoolClientResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteUserPoolClientRequest, DeleteUserPoolClientResponse>()
                    .withMarshaller(new DeleteUserPoolClientRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteUserPoolClientRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            DeleteUserPoolDomainRequest deleteUserPoolDomainRequest) {
        try {

            HttpResponseHandler<DeleteUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DeleteUserPoolDomainResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DeleteUserPoolDomainRequest, DeleteUserPoolDomainResponse>()
                    .withMarshaller(new DeleteUserPoolDomainRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteUserPoolDomainRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific identity provider.
     * </p>
     *
     * @param describeIdentityProviderRequest
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            DescribeIdentityProviderRequest describeIdentityProviderRequest) {
        try {

            HttpResponseHandler<DescribeIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeIdentityProviderResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeIdentityProviderRequest, DescribeIdentityProviderResponse>()
                            .withMarshaller(new DescribeIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeIdentityProviderRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     *
     * @param describeResourceServerRequest
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            DescribeResourceServerRequest describeResourceServerRequest) {
        try {

            HttpResponseHandler<DescribeResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeResourceServerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceServerRequest, DescribeResourceServerResponse>()
                            .withMarshaller(new DescribeResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeResourceServerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     *
     * @param describeUserImportJobRequest
     *        Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            DescribeUserImportJobRequest describeUserImportJobRequest) {
        try {

            HttpResponseHandler<DescribeUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeUserImportJobResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DescribeUserImportJobRequest, DescribeUserImportJobResponse>()
                    .withMarshaller(new DescribeUserImportJobRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeUserImportJobRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     *
     * @param describeUserPoolRequest
     *        Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolResponse> describeUserPool(DescribeUserPoolRequest describeUserPoolRequest) {
        try {

            HttpResponseHandler<DescribeUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeUserPoolResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<DescribeUserPoolRequest, DescribeUserPoolResponse>()
                    .withMarshaller(new DescribeUserPoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeUserPoolRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool client.
     * </p>
     *
     * @param describeUserPoolClientRequest
     *        Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            DescribeUserPoolClientRequest describeUserPoolClientRequest) {
        try {

            HttpResponseHandler<DescribeUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeUserPoolClientResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolClientRequest, DescribeUserPoolClientResponse>()
                            .withMarshaller(new DescribeUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeUserPoolClientRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     *
     * @param describeUserPoolDomainRequest
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            DescribeUserPoolDomainRequest describeUserPoolDomainRequest) {
        try {

            HttpResponseHandler<DescribeUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new DescribeUserPoolDomainResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolDomainRequest, DescribeUserPoolDomainResponse>()
                            .withMarshaller(new DescribeUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeUserPoolDomainRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forgets the specified device.
     * </p>
     *
     * @param forgetDeviceRequest
     *        Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ForgetDeviceResponse> forgetDevice(ForgetDeviceRequest forgetDeviceRequest) {
        try {

            HttpResponseHandler<ForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ForgetDeviceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ForgetDeviceRequest, ForgetDeviceResponse>()
                    .withMarshaller(new ForgetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(forgetDeviceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. If a
     * verified phone number exists for the user, the confirmation code is sent to the phone number. Otherwise, if a
     * verified email exists, the confirmation code is sent to the email. If neither a verified phone number nor a
     * verified email exists, <code>InvalidParameterException</code> is thrown. To use the confirmation code for
     * resetting the password, call <a href="API_ConfirmForgotPassword.html">ConfirmForgotPassword</a>.
     * </p>
     *
     * @param forgotPasswordRequest
     *        Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ForgotPasswordResponse> forgotPassword(ForgotPasswordRequest forgotPasswordRequest) {
        try {

            HttpResponseHandler<ForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ForgotPasswordResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ForgotPasswordRequest, ForgotPasswordResponse>()
                    .withMarshaller(new ForgotPasswordRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(forgotPasswordRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the header information for the .csv file to be used as input for the user import job.
     * </p>
     *
     * @param getCsvHeaderRequest
     *        Represents the request to get the header information for the .csv file for the user import job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCsvHeaderResponse> getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) {
        try {

            HttpResponseHandler<GetCsvHeaderResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetCsvHeaderResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetCsvHeaderRequest, GetCsvHeaderResponse>()
                    .withMarshaller(new GetCsvHeaderRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCsvHeaderRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the device.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        try {

            HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetDeviceResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>()
                    .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        try {

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>()
                    .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the specified identity provider.
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) {
        try {

            HttpResponseHandler<GetIdentityProviderByIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetIdentityProviderByIdentifierResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<GetIdentityProviderByIdentifierRequest, GetIdentityProviderByIdentifierResponse>()
                            .withMarshaller(new GetIdentityProviderByIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getIdentityProviderByIdentifierRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing
     * is set for the particular client, but there is an existing pool level customization (app <code>clientId</code>
     * will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.
     * </p>
     *
     * @param getUiCustomizationRequest
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUiCustomizationResponse> getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest) {
        try {

            HttpResponseHandler<GetUiCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetUiCustomizationResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetUiCustomizationRequest, GetUiCustomizationResponse>()
                    .withMarshaller(new GetUiCustomizationRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getUiCustomizationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     *
     * @param getUserRequest
     *        Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        try {

            HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GetUserResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>()
                    .withMarshaller(new GetUserRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUserRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the user attribute verification code for the specified attribute name.
     * </p>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        try {

            HttpResponseHandler<GetUserAttributeVerificationCodeResponse> responseHandler = protocolFactory
                    .createResponseHandler(
                            new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                            new GetUserAttributeVerificationCodeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<GetUserAttributeVerificationCodeRequest, GetUserAttributeVerificationCodeResponse>()
                            .withMarshaller(new GetUserAttributeVerificationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getUserAttributeVerificationCodeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Signs out users from all devices.
     * </p>
     *
     * @param globalSignOutRequest
     *        Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GlobalSignOutResponse> globalSignOut(GlobalSignOutRequest globalSignOutRequest) {
        try {

            HttpResponseHandler<GlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new GlobalSignOutResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<GlobalSignOutRequest, GlobalSignOutResponse>()
                    .withMarshaller(new GlobalSignOutRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(globalSignOutRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the authentication flow.
     * </p>
     *
     * @param initiateAuthRequest
     *        Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<InitiateAuthResponse> initiateAuth(InitiateAuthRequest initiateAuthRequest) {
        try {

            HttpResponseHandler<InitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new InitiateAuthResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<InitiateAuthRequest, InitiateAuthResponse>()
                    .withMarshaller(new InitiateAuthRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(initiateAuthRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the devices.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        try {

            HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListDevicesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                    .withMarshaller(new ListDevicesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDevicesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        try {

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListGroupsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>()
                    .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGroupsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        try {

            HttpResponseHandler<ListIdentityProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListIdentityProvidersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListIdentityProvidersRequest, ListIdentityProvidersResponse>()
                    .withMarshaller(new ListIdentityProvidersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listIdentityProvidersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     *
     * @param listResourceServersRequest
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceServersResponse> listResourceServers(
            ListResourceServersRequest listResourceServersRequest) {
        try {

            HttpResponseHandler<ListResourceServersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListResourceServersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListResourceServersRequest, ListResourceServersResponse>()
                    .withMarshaller(new ListResourceServersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listResourceServersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the user import jobs.
     * </p>
     *
     * @param listUserImportJobsRequest
     *        Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest) {
        try {

            HttpResponseHandler<ListUserImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListUserImportJobsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListUserImportJobsRequest, ListUserImportJobsResponse>()
                    .withMarshaller(new ListUserImportJobsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listUserImportJobsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            ListUserPoolClientsRequest listUserPoolClientsRequest) {
        try {

            HttpResponseHandler<ListUserPoolClientsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListUserPoolClientsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListUserPoolClientsRequest, ListUserPoolClientsResponse>()
                    .withMarshaller(new ListUserPoolClientsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listUserPoolClientsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoolsResponse> listUserPools(ListUserPoolsRequest listUserPoolsRequest) {
        try {

            HttpResponseHandler<ListUserPoolsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListUserPoolsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListUserPoolsRequest, ListUserPoolsResponse>()
                    .withMarshaller(new ListUserPoolsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUserPoolsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        try {

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListUsersResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>()
                    .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUsersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param listUsersInGroupRequest
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest) {
        try {

            HttpResponseHandler<ListUsersInGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ListUsersInGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<ListUsersInGroupRequest, ListUsersInGroupResponse>()
                    .withMarshaller(new ListUsersInGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUsersInGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     *
     * @param resendConfirmationCodeRequest
     *        Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        try {

            HttpResponseHandler<ResendConfirmationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new ResendConfirmationCodeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<ResendConfirmationCodeRequest, ResendConfirmationCodeResponse>()
                            .withMarshaller(new ResendConfirmationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(resendConfirmationCodeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Responds to the authentication challenge.
     * </p>
     *
     * @param respondToAuthChallengeRequest
     *        The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito cannot find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        try {

            HttpResponseHandler<RespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new RespondToAuthChallengeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<RespondToAuthChallengeRequest, RespondToAuthChallengeResponse>()
                            .withMarshaller(new RespondToAuthChallengeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(respondToAuthChallengeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the UI customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration will be used for every client that has no UI customization set previously. If you specify
     * UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code>
     * configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note>
     *
     * @param setUiCustomizationRequest
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUiCustomizationResponse> setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest) {
        try {

            HttpResponseHandler<SetUiCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new SetUiCustomizationResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<SetUiCustomizationRequest, SetUiCustomizationResponse>()
                    .withMarshaller(new SetUiCustomizationRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(setUiCustomizationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the user settings like multi-factor authentication (MFA). If MFA is to be removed for a particular attribute
     * pass the attribute with code delivery as null. If null list is passed, all MFA options are removed.
     * </p>
     *
     * @param setUserSettingsRequest
     *        Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserSettingsResponse> setUserSettings(SetUserSettingsRequest setUserSettingsRequest) {
        try {

            HttpResponseHandler<SetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new SetUserSettingsResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<SetUserSettingsRequest, SetUserSettingsResponse>()
                    .withMarshaller(new SetUserSettingsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(setUserSettingsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     *
     * @param signUpRequest
     *        Represents the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid password.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SignUpResponse> signUp(SignUpRequest signUpRequest) {
        try {

            HttpResponseHandler<SignUpResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new SignUpResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<SignUpRequest, SignUpResponse>()
                    .withMarshaller(new SignUpRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(signUpRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     *
     * @param startUserImportJobRequest
     *        Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartUserImportJobResponse> startUserImportJob(StartUserImportJobRequest startUserImportJobRequest) {
        try {

            HttpResponseHandler<StartUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StartUserImportJobResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<StartUserImportJobRequest, StartUserImportJobResponse>()
                    .withMarshaller(new StartUserImportJobRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(startUserImportJobRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     *
     * @param stopUserImportJobRequest
     *        Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopUserImportJobResponse> stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest) {
        try {

            HttpResponseHandler<StopUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new StopUserImportJobResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<StopUserImportJobRequest, StopUserImportJobResponse>()
                    .withMarshaller(new StopUserImportJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopUserImportJobRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the device status.
     * </p>
     *
     * @param updateDeviceStatusRequest
     *        Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         invalid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        try {

            HttpResponseHandler<UpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateDeviceStatusResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateDeviceStatusRequest, UpdateDeviceStatusResponse>()
                    .withMarshaller(new UpdateDeviceStatusRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateDeviceStatusRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <p>
     * Requires developer credentials.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        try {

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateGroupResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                    .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates identity provider information for a user pool.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier is not
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        try {

            HttpResponseHandler<UpdateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateIdentityProviderResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>()
                            .withMarshaller(new UpdateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateIdentityProviderRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     *
     * @param updateResourceServerRequest
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            UpdateResourceServerRequest updateResourceServerRequest) {
        try {

            HttpResponseHandler<UpdateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateResourceServerResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateResourceServerRequest, UpdateResourceServerResponse>()
                    .withMarshaller(new UpdateResourceServerRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateResourceServerRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a user to update a specific attribute (one at a time).
     * </p>
     *
     * @param updateUserAttributesRequest
     *        Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when the Amazon Cognito service encounters an
     *         unexpected exception with the AWS Lambda service.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the AWS Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid AWS Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         or phone number that has already been supplied as an alias from a different account. This exception tells
     *         user that an account with this email or phone already exists.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            UpdateUserAttributesRequest updateUserAttributesRequest) {
        try {

            HttpResponseHandler<UpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateUserAttributesResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateUserAttributesRequest, UpdateUserAttributesResponse>()
                    .withMarshaller(new UpdateUserAttributesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateUserAttributesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified user pool with the specified attributes.
     * </p>
     *
     * @param updateUserPoolRequest
     *        Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you are trying to modify a user pool
     *         while a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration does not have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is
     *         invalid for the role provided for SMS configuration. This can happen if you do not trust
     *         <b>cognito-idp.amazonaws.com</b> or the external ID provided in the role does not match what is provided
     *         in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag cannot be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito is not allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolResponse> updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) {
        try {

            HttpResponseHandler<UpdateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateUserPoolResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateUserPoolRequest, UpdateUserPoolResponse>()
                    .withMarshaller(new UpdateUserPoolRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUserPoolRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the developer to update the specified user pool client and password policy.
     * </p>
     *
     * @param updateUserPoolClientRequest
     *        Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope does not exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is invalid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            UpdateUserPoolClientRequest updateUserPoolClientRequest) {
        try {

            HttpResponseHandler<UpdateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new UpdateUserPoolClientResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<UpdateUserPoolClientRequest, UpdateUserPoolClientResponse>()
                    .withMarshaller(new UpdateUserPoolClientRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateUserPoolClientRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     *
     * @param verifyUserAttributeRequest
     *        Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service cannot find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code does not match what the server
     *         was expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user is not authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested AWS
     *         resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user is not found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user is not confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            VerifyUserAttributeRequest verifyUserAttributeRequest) {
        try {

            HttpResponseHandler<VerifyUserAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                    new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                    new VerifyUserAttributeResponseUnmarshaller());

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

            return clientHandler.execute(new ClientExecutionParams<VerifyUserAttributeRequest, VerifyUserAttributeResponse>()
                    .withMarshaller(new VerifyUserAttributeRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(verifyUserAttributeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata()
                .withSupportsCbor(supportsCbor)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(
                        software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(
                                ConcurrentModificationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidLambdaResponseException").withModeledClass(
                                InvalidLambdaResponseException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidOAuthFlowException").withModeledClass(
                                InvalidOAuthFlowException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSmsRoleAccessPolicyException").withModeledClass(
                                InvalidSmsRoleAccessPolicyException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UsernameExistsException").withModeledClass(
                                UsernameExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UserImportInProgressException").withModeledClass(
                                UserImportInProgressException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MFAMethodNotFoundException").withModeledClass(
                                MfaMethodNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ExpiredCodeException").withModeledClass(
                                ExpiredCodeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                LimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UserNotFoundException").withModeledClass(
                                UserNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidPasswordException").withModeledClass(
                                InvalidPasswordException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(
                                ResourceNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AliasExistsException").withModeledClass(
                                AliasExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedUserStateException").withModeledClass(
                                UnsupportedUserStateException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedException").withModeledClass(
                                NotAuthorizedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedIdentityProviderException").withModeledClass(
                                UnsupportedIdentityProviderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UserNotConfirmedException").withModeledClass(
                                UserNotConfirmedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("PasswordResetRequiredException").withModeledClass(
                                PasswordResetRequiredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnexpectedLambdaException").withModeledClass(
                                UnexpectedLambdaException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DuplicateProviderException").withModeledClass(
                                DuplicateProviderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(
                                InvalidParameterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UserLambdaValidationException").withModeledClass(
                                UserLambdaValidationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSmsRoleTrustRelationshipException").withModeledClass(
                                InvalidSmsRoleTrustRelationshipException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TooManyFailedAttemptsException").withModeledClass(
                                TooManyFailedAttemptsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("CodeDeliveryFailureException").withModeledClass(
                                CodeDeliveryFailureException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ScopeDoesNotExistException").withModeledClass(
                                ScopeDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(
                                InternalErrorException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidEmailRoleAccessPolicyException").withModeledClass(
                                InvalidEmailRoleAccessPolicyException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("PreconditionNotMetException").withModeledClass(
                                PreconditionNotMetException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("GroupExistsException").withModeledClass(
                                GroupExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UserPoolTaggingException").withModeledClass(
                                UserPoolTaggingException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidUserPoolConfigurationException").withModeledClass(
                                InvalidUserPoolConfigurationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(
                                TooManyRequestsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("CodeMismatchException").withModeledClass(
                                CodeMismatchException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                .protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}
