/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server to the request to create the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminCreateUserResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AdminCreateUserResponse.Builder, AdminCreateUserResponse> {
    private final UserType user;

    private AdminCreateUserResponse(BuilderImpl builder) {
        super(builder);
        this.user = builder.user;
    }

    /**
     * <p>
     * The newly created user.
     * </p>
     * 
     * @return The newly created user.
     */
    public UserType user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserResponse)) {
            return false;
        }
        AdminCreateUserResponse other = (AdminCreateUserResponse) obj;
        return Objects.equals(user(), other.user());
    }

    @Override
    public String toString() {
        return ToString.builder("AdminCreateUserResponse").add("User", user()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, CopyableBuilder<Builder, AdminCreateUserResponse> {
        /**
         * <p>
         * The newly created user.
         * </p>
         * 
         * @param user
         *        The newly created user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(UserType user);

        /**
         * <p>
         * The newly created user.
         * </p>
         * This is a convenience that creates an instance of the {@link UserType.Builder} avoiding the need to create
         * one manually via {@link UserType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserType.Builder#build()} is called immediately and its result is
         * passed to {@link #user(UserType)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link UserType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(UserType)
         */
        default Builder user(Consumer<UserType.Builder> user) {
            return user(UserType.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UserType user;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminCreateUserResponse model) {
            super(model);
            user(model.user);
        }

        public final UserType.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        @Override
        public final Builder user(UserType user) {
            this.user = user;
            return this;
        }

        public final void setUser(UserType.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public AdminCreateUserResponse build() {
            return new AdminCreateUserResponse(this);
        }
    }
}
