/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request representing the confirmation for a password reset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmForgotPasswordRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<ConfirmForgotPasswordRequest.Builder, ConfirmForgotPasswordRequest> {
    private final String clientId;

    private final String secretHash;

    private final String username;

    private final String confirmationCode;

    private final String password;

    private ConfirmForgotPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.secretHash = builder.secretHash;
        this.username = builder.username;
        this.confirmationCode = builder.confirmationCode;
        this.password = builder.password;
    }

    /**
     * <p>
     * The app client ID of the app associated with the user pool.
     * </p>
     * 
     * @return The app client ID of the app associated with the user pool.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and
     * username plus the client ID in the message.
     * </p>
     * 
     * @return A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and
     *         username plus the client ID in the message.
     */
    public String secretHash() {
        return secretHash;
    }

    /**
     * <p>
     * The user name of the user for whom you want to enter a code to retrieve a forgotten password.
     * </p>
     * 
     * @return The user name of the user for whom you want to enter a code to retrieve a forgotten password.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a
     * href="API_ForgotPassword.html">ForgotPassword</a>
     * </p>
     * 
     * @return The confirmation code sent by a user's request to retrieve a forgotten password. For more information,
     *         see <a href="API_ForgotPassword.html">ForgotPassword</a>
     */
    public String confirmationCode() {
        return confirmationCode;
    }

    /**
     * <p>
     * The password sent by a user's request to retrieve a forgotten password.
     * </p>
     * 
     * @return The password sent by a user's request to retrieve a forgotten password.
     */
    public String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(secretHash());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationCode());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmForgotPasswordRequest)) {
            return false;
        }
        ConfirmForgotPasswordRequest other = (ConfirmForgotPasswordRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(secretHash(), other.secretHash())
                && Objects.equals(username(), other.username()) && Objects.equals(confirmationCode(), other.confirmationCode())
                && Objects.equals(password(), other.password());
    }

    @Override
    public String toString() {
        return ToString.builder("ConfirmForgotPasswordRequest").add("ClientId", clientId()).add("SecretHash", secretHash())
                .add("Username", username()).add("ConfirmationCode", confirmationCode()).add("Password", password()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "SecretHash":
            return Optional.ofNullable(clazz.cast(secretHash()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "ConfirmationCode":
            return Optional.ofNullable(clazz.cast(confirmationCode()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder,
            CopyableBuilder<Builder, ConfirmForgotPasswordRequest> {
        /**
         * <p>
         * The app client ID of the app associated with the user pool.
         * </p>
         * 
         * @param clientId
         *        The app client ID of the app associated with the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and
         * username plus the client ID in the message.
         * </p>
         * 
         * @param secretHash
         *        A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client
         *        and username plus the client ID in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretHash(String secretHash);

        /**
         * <p>
         * The user name of the user for whom you want to enter a code to retrieve a forgotten password.
         * </p>
         * 
         * @param username
         *        The user name of the user for whom you want to enter a code to retrieve a forgotten password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The confirmation code sent by a user's request to retrieve a forgotten password. For more information, see <a
         * href="API_ForgotPassword.html">ForgotPassword</a>
         * </p>
         * 
         * @param confirmationCode
         *        The confirmation code sent by a user's request to retrieve a forgotten password. For more information,
         *        see <a href="API_ForgotPassword.html">ForgotPassword</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationCode(String confirmationCode);

        /**
         * <p>
         * The password sent by a user's request to retrieve a forgotten password.
         * </p>
         * 
         * @param password
         *        The password sent by a user's request to retrieve a forgotten password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String clientId;

        private String secretHash;

        private String username;

        private String confirmationCode;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmForgotPasswordRequest model) {
            super(model);
            clientId(model.clientId);
            secretHash(model.secretHash);
            username(model.username);
            confirmationCode(model.confirmationCode);
            password(model.password);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getSecretHash() {
            return secretHash;
        }

        @Override
        public final Builder secretHash(String secretHash) {
            this.secretHash = secretHash;
            return this;
        }

        public final void setSecretHash(String secretHash) {
            this.secretHash = secretHash;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getConfirmationCode() {
            return confirmationCode;
        }

        @Override
        public final Builder confirmationCode(String confirmationCode) {
            this.confirmationCode = confirmationCode;
            return this;
        }

        public final void setConfirmationCode(String confirmationCode) {
            this.confirmationCode = confirmationCode;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmForgotPasswordRequest build() {
            return new ConfirmForgotPasswordRequest(this);
        }
    }
}
