/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to delete user attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUserAttributesRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<DeleteUserAttributesRequest.Builder, DeleteUserAttributesRequest> {
    private final List<String> userAttributeNames;

    private final String accessToken;

    private DeleteUserAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userAttributeNames = builder.userAttributeNames;
        this.accessToken = builder.accessToken;
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you wish to delete.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of strings representing the user attribute names you wish to delete.</p>
     *         <p>
     *         For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     */
    public List<String> userAttributeNames() {
        return userAttributeNames;
    }

    /**
     * <p>
     * The access token used in the request to delete user attributes.
     * </p>
     * 
     * @return The access token used in the request to delete user attributes.
     */
    public String accessToken() {
        return accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserAttributesRequest)) {
            return false;
        }
        DeleteUserAttributesRequest other = (DeleteUserAttributesRequest) obj;
        return Objects.equals(userAttributeNames(), other.userAttributeNames())
                && Objects.equals(accessToken(), other.accessToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteUserAttributesRequest").add("UserAttributeNames", userAttributeNames())
                .add("AccessToken", accessToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserAttributeNames":
            return Optional.ofNullable(clazz.cast(userAttributeNames()));
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder,
            CopyableBuilder<Builder, DeleteUserAttributesRequest> {
        /**
         * <p>
         * An array of strings representing the user attribute names you wish to delete.
         * </p>
         * <p>
         * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * </p>
         * 
         * @param userAttributeNames
         *        An array of strings representing the user attribute names you wish to delete.</p>
         *        <p>
         *        For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributeNames(Collection<String> userAttributeNames);

        /**
         * <p>
         * An array of strings representing the user attribute names you wish to delete.
         * </p>
         * <p>
         * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * </p>
         * 
         * @param userAttributeNames
         *        An array of strings representing the user attribute names you wish to delete.</p>
         *        <p>
         *        For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributeNames(String... userAttributeNames);

        /**
         * <p>
         * The access token used in the request to delete user attributes.
         * </p>
         * 
         * @param accessToken
         *        The access token used in the request to delete user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private List<String> userAttributeNames = DefaultSdkAutoConstructList.getInstance();

        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserAttributesRequest model) {
            super(model);
            userAttributeNames(model.userAttributeNames);
            accessToken(model.accessToken);
        }

        public final Collection<String> getUserAttributeNames() {
            return userAttributeNames;
        }

        @Override
        public final Builder userAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributeNames(String... userAttributeNames) {
            userAttributeNames(Arrays.asList(userAttributeNames));
            return this;
        }

        public final void setUserAttributeNames(Collection<String> userAttributeNames) {
            this.userAttributeNames = AttributeNameListTypeCopier.copy(userAttributeNames);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserAttributesRequest build() {
            return new DeleteUserAttributesRequest(this);
        }
    }
}
