/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityProviderByIdentifierRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<GetIdentityProviderByIdentifierRequest.Builder, GetIdentityProviderByIdentifierRequest> {
    private final String userPoolId;

    private final String idpIdentifier;

    private GetIdentityProviderByIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.idpIdentifier = builder.idpIdentifier;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The identity provider ID.
     * </p>
     * 
     * @return The identity provider ID.
     */
    public String idpIdentifier() {
        return idpIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(idpIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityProviderByIdentifierRequest)) {
            return false;
        }
        GetIdentityProviderByIdentifierRequest other = (GetIdentityProviderByIdentifierRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(idpIdentifier(), other.idpIdentifier());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIdentityProviderByIdentifierRequest").add("UserPoolId", userPoolId())
                .add("IdpIdentifier", idpIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "IdpIdentifier":
            return Optional.ofNullable(clazz.cast(idpIdentifier()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder,
            CopyableBuilder<Builder, GetIdentityProviderByIdentifierRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The identity provider ID.
         * </p>
         * 
         * @param idpIdentifier
         *        The identity provider ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpIdentifier(String idpIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String idpIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityProviderByIdentifierRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            idpIdentifier(model.idpIdentifier);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getIdpIdentifier() {
            return idpIdentifier;
        }

        @Override
        public final Builder idpIdentifier(String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
            return this;
        }

        public final void setIdpIdentifier(String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityProviderByIdentifierRequest build() {
            return new GetIdentityProviderByIdentifierRequest(this);
        }
    }
}
