/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The verification code response returned by the server response to get the user attribute verification code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserAttributeVerificationCodeResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetUserAttributeVerificationCodeResponse.Builder, GetUserAttributeVerificationCodeResponse> {
    private final CodeDeliveryDetailsType codeDeliveryDetails;

    private GetUserAttributeVerificationCodeResponse(BuilderImpl builder) {
        super(builder);
        this.codeDeliveryDetails = builder.codeDeliveryDetails;
    }

    /**
     * <p>
     * The code delivery details returned by the server in response to the request to get the user attribute
     * verification code.
     * </p>
     * 
     * @return The code delivery details returned by the server in response to the request to get the user attribute
     *         verification code.
     */
    public CodeDeliveryDetailsType codeDeliveryDetails() {
        return codeDeliveryDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeDeliveryDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserAttributeVerificationCodeResponse)) {
            return false;
        }
        GetUserAttributeVerificationCodeResponse other = (GetUserAttributeVerificationCodeResponse) obj;
        return Objects.equals(codeDeliveryDetails(), other.codeDeliveryDetails());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUserAttributeVerificationCodeResponse").add("CodeDeliveryDetails", codeDeliveryDetails())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeDeliveryDetails":
            return Optional.ofNullable(clazz.cast(codeDeliveryDetails()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder,
            CopyableBuilder<Builder, GetUserAttributeVerificationCodeResponse> {
        /**
         * <p>
         * The code delivery details returned by the server in response to the request to get the user attribute
         * verification code.
         * </p>
         * 
         * @param codeDeliveryDetails
         *        The code delivery details returned by the server in response to the request to get the user attribute
         *        verification code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails);

        /**
         * <p>
         * The code delivery details returned by the server in response to the request to get the user attribute
         * verification code.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeDeliveryDetailsType.Builder} avoiding the
         * need to create one manually via {@link CodeDeliveryDetailsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeDeliveryDetailsType.Builder#build()} is called immediately
         * and its result is passed to {@link #codeDeliveryDetails(CodeDeliveryDetailsType)}.
         * 
         * @param codeDeliveryDetails
         *        a consumer that will call methods on {@link CodeDeliveryDetailsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeDeliveryDetails(CodeDeliveryDetailsType)
         */
        default Builder codeDeliveryDetails(Consumer<CodeDeliveryDetailsType.Builder> codeDeliveryDetails) {
            return codeDeliveryDetails(CodeDeliveryDetailsType.builder().applyMutation(codeDeliveryDetails).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private CodeDeliveryDetailsType codeDeliveryDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserAttributeVerificationCodeResponse model) {
            super(model);
            codeDeliveryDetails(model.codeDeliveryDetails);
        }

        public final CodeDeliveryDetailsType.Builder getCodeDeliveryDetails() {
            return codeDeliveryDetails != null ? codeDeliveryDetails.toBuilder() : null;
        }

        @Override
        public final Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails;
            return this;
        }

        public final void setCodeDeliveryDetails(CodeDeliveryDetailsType.BuilderImpl codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails != null ? codeDeliveryDetails.build() : null;
        }

        @Override
        public GetUserAttributeVerificationCodeResponse build() {
            return new GetUserAttributeVerificationCodeResponse(this);
        }
    }
}
