/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersInGroupResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListUsersInGroupResponse.Builder, ListUsersInGroupResponse> {
    private final List<UserType> users;

    private final String nextToken;

    private ListUsersInGroupResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The users returned in the request to list users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The users returned in the request to list users.
     */
    public List<UserType> users() {
        return users;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(users());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersInGroupResponse)) {
            return false;
        }
        ListUsersInGroupResponse other = (ListUsersInGroupResponse) obj;
        return Objects.equals(users(), other.users()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListUsersInGroupResponse").add("Users", users()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, CopyableBuilder<Builder, ListUsersInGroupResponse> {
        /**
         * <p>
         * The users returned in the request to list users.
         * </p>
         * 
         * @param users
         *        The users returned in the request to list users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserType> users);

        /**
         * <p>
         * The users returned in the request to list users.
         * </p>
         * 
         * @param users
         *        The users returned in the request to list users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserType... users);

        /**
         * <p>
         * The users returned in the request to list users.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserType>.Builder} avoiding the need to
         * create one manually via {@link List<UserType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserType>.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<UserType>)}.
         * 
         * @param users
         *        a consumer that will call methods on {@link List<UserType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(List<UserType>)
         */
        Builder users(Consumer<UserType.Builder>... users);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<UserType> users = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersInGroupResponse model) {
            super(model);
            users(model.users);
            nextToken(model.nextToken);
        }

        public final Collection<UserType.Builder> getUsers() {
            return users != null ? users.stream().map(UserType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserType> users) {
            this.users = UsersListTypeCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserType... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserType.Builder>... users) {
            users(Stream.of(users).map(c -> UserType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserType.BuilderImpl> users) {
            this.users = UsersListTypeCopier.copyFromBuilder(users);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUsersInGroupResponse build() {
            return new ListUsersInGroupResponse(this);
        }
    }
}
