/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.NewDeviceMetadataTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The new device metadata type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewDeviceMetadataType implements StructuredPojo,
        ToCopyableBuilder<NewDeviceMetadataType.Builder, NewDeviceMetadataType> {
    private final String deviceKey;

    private final String deviceGroupKey;

    private NewDeviceMetadataType(BuilderImpl builder) {
        this.deviceKey = builder.deviceKey;
        this.deviceGroupKey = builder.deviceGroupKey;
    }

    /**
     * <p>
     * The device key.
     * </p>
     * 
     * @return The device key.
     */
    public String deviceKey() {
        return deviceKey;
    }

    /**
     * <p>
     * The device group key.
     * </p>
     * 
     * @return The device group key.
     */
    public String deviceGroupKey() {
        return deviceGroupKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(deviceGroupKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewDeviceMetadataType)) {
            return false;
        }
        NewDeviceMetadataType other = (NewDeviceMetadataType) obj;
        return Objects.equals(deviceKey(), other.deviceKey()) && Objects.equals(deviceGroupKey(), other.deviceGroupKey());
    }

    @Override
    public String toString() {
        return ToString.builder("NewDeviceMetadataType").add("DeviceKey", deviceKey()).add("DeviceGroupKey", deviceGroupKey())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceKey":
            return Optional.ofNullable(clazz.cast(deviceKey()));
        case "DeviceGroupKey":
            return Optional.ofNullable(clazz.cast(deviceGroupKey()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewDeviceMetadataTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NewDeviceMetadataType> {
        /**
         * <p>
         * The device key.
         * </p>
         * 
         * @param deviceKey
         *        The device key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceKey(String deviceKey);

        /**
         * <p>
         * The device group key.
         * </p>
         * 
         * @param deviceGroupKey
         *        The device group key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceGroupKey(String deviceGroupKey);
    }

    static final class BuilderImpl implements Builder {
        private String deviceKey;

        private String deviceGroupKey;

        private BuilderImpl() {
        }

        private BuilderImpl(NewDeviceMetadataType model) {
            deviceKey(model.deviceKey);
            deviceGroupKey(model.deviceGroupKey);
        }

        public final String getDeviceKey() {
            return deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getDeviceGroupKey() {
            return deviceGroupKey;
        }

        @Override
        public final Builder deviceGroupKey(String deviceGroupKey) {
            this.deviceGroupKey = deviceGroupKey;
            return this;
        }

        public final void setDeviceGroupKey(String deviceGroupKey) {
            this.deviceGroupKey = deviceGroupKey;
        }

        @Override
        public NewDeviceMetadataType build() {
            return new NewDeviceMetadataType(this);
        }
    }
}
