/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.NumberAttributeConstraintsTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum and maximum value of an attribute that is of the number data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberAttributeConstraintsType implements StructuredPojo,
        ToCopyableBuilder<NumberAttributeConstraintsType.Builder, NumberAttributeConstraintsType> {
    private final String minValue;

    private final String maxValue;

    private NumberAttributeConstraintsType(BuilderImpl builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    /**
     * <p>
     * The minimum value of an attribute that is of the number data type.
     * </p>
     * 
     * @return The minimum value of an attribute that is of the number data type.
     */
    public String minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum value of an attribute that is of the number data type.
     * </p>
     * 
     * @return The maximum value of an attribute that is of the number data type.
     */
    public String maxValue() {
        return maxValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberAttributeConstraintsType)) {
            return false;
        }
        NumberAttributeConstraintsType other = (NumberAttributeConstraintsType) obj;
        return Objects.equals(minValue(), other.minValue()) && Objects.equals(maxValue(), other.maxValue());
    }

    @Override
    public String toString() {
        return ToString.builder("NumberAttributeConstraintsType").add("MinValue", minValue()).add("MaxValue", maxValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NumberAttributeConstraintsTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NumberAttributeConstraintsType> {
        /**
         * <p>
         * The minimum value of an attribute that is of the number data type.
         * </p>
         * 
         * @param minValue
         *        The minimum value of an attribute that is of the number data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(String minValue);

        /**
         * <p>
         * The maximum value of an attribute that is of the number data type.
         * </p>
         * 
         * @param maxValue
         *        The maximum value of an attribute that is of the number data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(String maxValue);
    }

    static final class BuilderImpl implements Builder {
        private String minValue;

        private String maxValue;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberAttributeConstraintsType model) {
            minValue(model.minValue);
            maxValue(model.maxValue);
        }

        public final String getMinValue() {
            return minValue;
        }

        @Override
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public final String getMaxValue() {
            return maxValue;
        }

        @Override
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public NumberAttributeConstraintsType build() {
            return new NumberAttributeConstraintsType(this);
        }
    }
}
