/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResourceServerScopeTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource server scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceServerScopeType implements StructuredPojo,
        ToCopyableBuilder<ResourceServerScopeType.Builder, ResourceServerScopeType> {
    private final String scopeName;

    private final String scopeDescription;

    private ResourceServerScopeType(BuilderImpl builder) {
        this.scopeName = builder.scopeName;
        this.scopeDescription = builder.scopeDescription;
    }

    /**
     * <p>
     * The name of the scope.
     * </p>
     * 
     * @return The name of the scope.
     */
    public String scopeName() {
        return scopeName;
    }

    /**
     * <p>
     * A description of the scope.
     * </p>
     * 
     * @return A description of the scope.
     */
    public String scopeDescription() {
        return scopeDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scopeName());
        hashCode = 31 * hashCode + Objects.hashCode(scopeDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerScopeType)) {
            return false;
        }
        ResourceServerScopeType other = (ResourceServerScopeType) obj;
        return Objects.equals(scopeName(), other.scopeName()) && Objects.equals(scopeDescription(), other.scopeDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceServerScopeType").add("ScopeName", scopeName())
                .add("ScopeDescription", scopeDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScopeName":
            return Optional.ofNullable(clazz.cast(scopeName()));
        case "ScopeDescription":
            return Optional.ofNullable(clazz.cast(scopeDescription()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceServerScopeTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceServerScopeType> {
        /**
         * <p>
         * The name of the scope.
         * </p>
         * 
         * @param scopeName
         *        The name of the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeName(String scopeName);

        /**
         * <p>
         * A description of the scope.
         * </p>
         * 
         * @param scopeDescription
         *        A description of the scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeDescription(String scopeDescription);
    }

    static final class BuilderImpl implements Builder {
        private String scopeName;

        private String scopeDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceServerScopeType model) {
            scopeName(model.scopeName);
            scopeDescription(model.scopeDescription);
        }

        public final String getScopeName() {
            return scopeName;
        }

        @Override
        public final Builder scopeName(String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        public final void setScopeName(String scopeName) {
            this.scopeName = scopeName;
        }

        public final String getScopeDescription() {
            return scopeDescription;
        }

        @Override
        public final Builder scopeDescription(String scopeDescription) {
            this.scopeDescription = scopeDescription;
            return this;
        }

        public final void setScopeDescription(String scopeDescription) {
            this.scopeDescription = scopeDescription;
        }

        @Override
        public ResourceServerScopeType build() {
            return new ResourceServerScopeType(this);
        }
    }
}
