/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerificationMessageTemplateTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The template for verification messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerificationMessageTemplateType implements StructuredPojo,
        ToCopyableBuilder<VerificationMessageTemplateType.Builder, VerificationMessageTemplateType> {
    private final String smsMessage;

    private final String emailMessage;

    private final String emailSubject;

    private final String emailMessageByLink;

    private final String emailSubjectByLink;

    private final String defaultEmailOption;

    private VerificationMessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
        this.emailMessageByLink = builder.emailMessageByLink;
        this.emailSubjectByLink = builder.emailSubjectByLink;
        this.defaultEmailOption = builder.defaultEmailOption;
    }

    /**
     * <p>
     * The SMS message template.
     * </p>
     * 
     * @return The SMS message template.
     */
    public String smsMessage() {
        return smsMessage;
    }

    /**
     * <p>
     * The email message template.
     * </p>
     * 
     * @return The email message template.
     */
    public String emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The subject line for the email message template.
     * </p>
     * 
     * @return The subject line for the email message template.
     */
    public String emailSubject() {
        return emailSubject;
    }

    /**
     * <p>
     * The email message template for sending a confirmation link to the user.
     * </p>
     * 
     * @return The email message template for sending a confirmation link to the user.
     */
    public String emailMessageByLink() {
        return emailMessageByLink;
    }

    /**
     * <p>
     * The subject line for the email message template for sending a confirmation link to the user.
     * </p>
     * 
     * @return The subject line for the email message template for sending a confirmation link to the user.
     */
    public String emailSubjectByLink() {
        return emailSubjectByLink;
    }

    /**
     * <p>
     * The default email option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultEmailOption} will return {@link DefaultEmailOptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultEmailOptionAsString}.
     * </p>
     * 
     * @return The default email option.
     * @see DefaultEmailOptionType
     */
    public DefaultEmailOptionType defaultEmailOption() {
        return DefaultEmailOptionType.fromValue(defaultEmailOption);
    }

    /**
     * <p>
     * The default email option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultEmailOption} will return {@link DefaultEmailOptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultEmailOptionAsString}.
     * </p>
     * 
     * @return The default email option.
     * @see DefaultEmailOptionType
     */
    public String defaultEmailOptionAsString() {
        return defaultEmailOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailSubject());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessageByLink());
        hashCode = 31 * hashCode + Objects.hashCode(emailSubjectByLink());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEmailOptionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationMessageTemplateType)) {
            return false;
        }
        VerificationMessageTemplateType other = (VerificationMessageTemplateType) obj;
        return Objects.equals(smsMessage(), other.smsMessage()) && Objects.equals(emailMessage(), other.emailMessage())
                && Objects.equals(emailSubject(), other.emailSubject())
                && Objects.equals(emailMessageByLink(), other.emailMessageByLink())
                && Objects.equals(emailSubjectByLink(), other.emailSubjectByLink())
                && Objects.equals(defaultEmailOptionAsString(), other.defaultEmailOptionAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("VerificationMessageTemplateType").add("SmsMessage", smsMessage())
                .add("EmailMessage", emailMessage()).add("EmailSubject", emailSubject())
                .add("EmailMessageByLink", emailMessageByLink()).add("EmailSubjectByLink", emailSubjectByLink())
                .add("DefaultEmailOption", defaultEmailOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmsMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "EmailSubject":
            return Optional.ofNullable(clazz.cast(emailSubject()));
        case "EmailMessageByLink":
            return Optional.ofNullable(clazz.cast(emailMessageByLink()));
        case "EmailSubjectByLink":
            return Optional.ofNullable(clazz.cast(emailSubjectByLink()));
        case "DefaultEmailOption":
            return Optional.ofNullable(clazz.cast(defaultEmailOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VerificationMessageTemplateTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, VerificationMessageTemplateType> {
        /**
         * <p>
         * The SMS message template.
         * </p>
         * 
         * @param smsMessage
         *        The SMS message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(String smsMessage);

        /**
         * <p>
         * The email message template.
         * </p>
         * 
         * @param emailMessage
         *        The email message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(String emailMessage);

        /**
         * <p>
         * The subject line for the email message template.
         * </p>
         * 
         * @param emailSubject
         *        The subject line for the email message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSubject(String emailSubject);

        /**
         * <p>
         * The email message template for sending a confirmation link to the user.
         * </p>
         * 
         * @param emailMessageByLink
         *        The email message template for sending a confirmation link to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessageByLink(String emailMessageByLink);

        /**
         * <p>
         * The subject line for the email message template for sending a confirmation link to the user.
         * </p>
         * 
         * @param emailSubjectByLink
         *        The subject line for the email message template for sending a confirmation link to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSubjectByLink(String emailSubjectByLink);

        /**
         * <p>
         * The default email option.
         * </p>
         * 
         * @param defaultEmailOption
         *        The default email option.
         * @see DefaultEmailOptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultEmailOptionType
         */
        Builder defaultEmailOption(String defaultEmailOption);

        /**
         * <p>
         * The default email option.
         * </p>
         * 
         * @param defaultEmailOption
         *        The default email option.
         * @see DefaultEmailOptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultEmailOptionType
         */
        Builder defaultEmailOption(DefaultEmailOptionType defaultEmailOption);
    }

    static final class BuilderImpl implements Builder {
        private String smsMessage;

        private String emailMessage;

        private String emailSubject;

        private String emailMessageByLink;

        private String emailSubjectByLink;

        private String defaultEmailOption;

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationMessageTemplateType model) {
            smsMessage(model.smsMessage);
            emailMessage(model.emailMessage);
            emailSubject(model.emailSubject);
            emailMessageByLink(model.emailMessageByLink);
            emailSubjectByLink(model.emailSubjectByLink);
            defaultEmailOption(model.defaultEmailOption);
        }

        public final String getSmsMessage() {
            return smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        public final String getEmailMessage() {
            return emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        public final String getEmailSubject() {
            return emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        public final String getEmailMessageByLink() {
            return emailMessageByLink;
        }

        @Override
        public final Builder emailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
            return this;
        }

        public final void setEmailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
        }

        public final String getEmailSubjectByLink() {
            return emailSubjectByLink;
        }

        @Override
        public final Builder emailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
            return this;
        }

        public final void setEmailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
        }

        public final String getDefaultEmailOption() {
            return defaultEmailOption;
        }

        @Override
        public final Builder defaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
            return this;
        }

        @Override
        public final Builder defaultEmailOption(DefaultEmailOptionType defaultEmailOption) {
            this.defaultEmailOption(defaultEmailOption.toString());
            return this;
        }

        public final void setDefaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
        }

        @Override
        public VerificationMessageTemplateType build() {
            return new VerificationMessageTemplateType(this);
        }
    }
}
