/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AdminRespondToAuthChallengeRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AdminRespondToAuthChallengeRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();

    private static final MarshallingInfo<String> CHALLENGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeName").isBinary(false).build();

    private static final MarshallingInfo<Map> CHALLENGERESPONSES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeResponses").isBinary(false).build();

    private static final MarshallingInfo<String> SESSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Session").isBinary(false).build();

    private static final AdminRespondToAuthChallengeRequestModelMarshaller INSTANCE = new AdminRespondToAuthChallengeRequestModelMarshaller();

    private AdminRespondToAuthChallengeRequestModelMarshaller() {
    }

    public static AdminRespondToAuthChallengeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(adminRespondToAuthChallengeRequest, "adminRespondToAuthChallengeRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(adminRespondToAuthChallengeRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(adminRespondToAuthChallengeRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(adminRespondToAuthChallengeRequest.challengeNameAsString(), CHALLENGENAME_BINDING);
            protocolMarshaller.marshall(adminRespondToAuthChallengeRequest.challengeResponses(), CHALLENGERESPONSES_BINDING);
            protocolMarshaller.marshall(adminRespondToAuthChallengeRequest.session(), SESSION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
