/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AuthenticationResultType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AuthenticationResultTypeMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> EXPIRESIN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpiresIn").isBinary(false).build();

    private static final MarshallingInfo<String> TOKENTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenType").isBinary(false).build();

    private static final MarshallingInfo<String> REFRESHTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshToken").isBinary(false).build();

    private static final MarshallingInfo<String> IDTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdToken").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NEWDEVICEMETADATA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NewDeviceMetadata").isBinary(false).build();

    private static final AuthenticationResultTypeMarshaller INSTANCE = new AuthenticationResultTypeMarshaller();

    private AuthenticationResultTypeMarshaller() {
    }

    public static AuthenticationResultTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AuthenticationResultType authenticationResultType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(authenticationResultType, "authenticationResultType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(authenticationResultType.accessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall(authenticationResultType.expiresIn(), EXPIRESIN_BINDING);
            protocolMarshaller.marshall(authenticationResultType.tokenType(), TOKENTYPE_BINDING);
            protocolMarshaller.marshall(authenticationResultType.refreshToken(), REFRESHTOKEN_BINDING);
            protocolMarshaller.marshall(authenticationResultType.idToken(), IDTOKEN_BINDING);
            protocolMarshaller.marshall(authenticationResultType.newDeviceMetadata(), NEWDEVICEMETADATA_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
