/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AuthenticationResultType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AuthenticationResultTypeUnmarshaller implements Unmarshaller<AuthenticationResultType, JsonUnmarshallerContext> {

    public AuthenticationResultType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuthenticationResultType.Builder authenticationResultTypeBuilder = AuthenticationResultType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AccessToken", targetDepth)) {
                    context.nextToken();
                    authenticationResultTypeBuilder.accessToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExpiresIn", targetDepth)) {
                    context.nextToken();
                    authenticationResultTypeBuilder.expiresIn(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("TokenType", targetDepth)) {
                    context.nextToken();
                    authenticationResultTypeBuilder.tokenType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RefreshToken", targetDepth)) {
                    context.nextToken();
                    authenticationResultTypeBuilder.refreshToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IdToken", targetDepth)) {
                    context.nextToken();
                    authenticationResultTypeBuilder.idToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NewDeviceMetadata", targetDepth)) {
                    context.nextToken();
                    authenticationResultTypeBuilder.newDeviceMetadata(NewDeviceMetadataTypeUnmarshaller.getInstance().unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return authenticationResultTypeBuilder.build();
    }

    private static final AuthenticationResultTypeUnmarshaller INSTANCE = new AuthenticationResultTypeUnmarshaller();

    public static AuthenticationResultTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
