/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ConfirmForgotPasswordResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ConfirmForgotPasswordResponseUnmarshaller implements
        Unmarshaller<ConfirmForgotPasswordResponse, JsonUnmarshallerContext> {

    public ConfirmForgotPasswordResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConfirmForgotPasswordResponse.Builder confirmForgotPasswordResponseBuilder = ConfirmForgotPasswordResponse.builder();

        return confirmForgotPasswordResponseBuilder.build();
    }

    private static final ConfirmForgotPasswordResponseUnmarshaller INSTANCE = new ConfirmForgotPasswordResponseUnmarshaller();

    public static ConfirmForgotPasswordResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
