/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DeviceSecretVerifierConfigType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DeviceSecretVerifierConfigTypeMarshaller {
    private static final MarshallingInfo<String> PASSWORDVERIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PasswordVerifier").isBinary(false).build();

    private static final MarshallingInfo<String> SALT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Salt").isBinary(false).build();

    private static final DeviceSecretVerifierConfigTypeMarshaller INSTANCE = new DeviceSecretVerifierConfigTypeMarshaller();

    private DeviceSecretVerifierConfigTypeMarshaller() {
    }

    public static DeviceSecretVerifierConfigTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DeviceSecretVerifierConfigType deviceSecretVerifierConfigType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(deviceSecretVerifierConfigType, "deviceSecretVerifierConfigType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(deviceSecretVerifierConfigType.passwordVerifier(), PASSWORDVERIFIER_BINDING);
            protocolMarshaller.marshall(deviceSecretVerifierConfigType.salt(), SALT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
