/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link LambdaConfigType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class LambdaConfigTypeMarshaller {
    private static final MarshallingInfo<String> PRESIGNUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreSignUp").isBinary(false).build();

    private static final MarshallingInfo<String> CUSTOMMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomMessage").isBinary(false).build();

    private static final MarshallingInfo<String> POSTCONFIRMATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostConfirmation").isBinary(false).build();

    private static final MarshallingInfo<String> PREAUTHENTICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreAuthentication").isBinary(false).build();

    private static final MarshallingInfo<String> POSTAUTHENTICATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostAuthentication").isBinary(false).build();

    private static final MarshallingInfo<String> DEFINEAUTHCHALLENGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefineAuthChallenge").isBinary(false).build();

    private static final MarshallingInfo<String> CREATEAUTHCHALLENGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateAuthChallenge").isBinary(false).build();

    private static final MarshallingInfo<String> VERIFYAUTHCHALLENGERESPONSE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("VerifyAuthChallengeResponse").isBinary(false).build();

    private static final LambdaConfigTypeMarshaller INSTANCE = new LambdaConfigTypeMarshaller();

    private LambdaConfigTypeMarshaller() {
    }

    public static LambdaConfigTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(LambdaConfigType lambdaConfigType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(lambdaConfigType, "lambdaConfigType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(lambdaConfigType.preSignUp(), PRESIGNUP_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.customMessage(), CUSTOMMESSAGE_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.postConfirmation(), POSTCONFIRMATION_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.preAuthentication(), PREAUTHENTICATION_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.postAuthentication(), POSTAUTHENTICATION_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.defineAuthChallenge(), DEFINEAUTHCHALLENGE_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.createAuthChallenge(), CREATEAUTHCHALLENGE_BINDING);
            protocolMarshaller.marshall(lambdaConfigType.verifyAuthChallengeResponse(), VERIFYAUTHCHALLENGERESPONSE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
