/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UICustomizationType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UICustomizationTypeUnmarshaller implements Unmarshaller<UICustomizationType, JsonUnmarshallerContext> {

    public UICustomizationType unmarshall(JsonUnmarshallerContext context) throws Exception {
        UICustomizationType.Builder uiCustomizationTypeBuilder = UICustomizationType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("UserPoolId", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.userPoolId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClientId", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.clientId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ImageUrl", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.imageUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CSS", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.css(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CSSVersion", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.cssVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.lastModifiedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    uiCustomizationTypeBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return uiCustomizationTypeBuilder.build();
    }

    private static final UICustomizationTypeUnmarshaller INSTANCE = new UICustomizationTypeUnmarshaller();

    public static UICustomizationTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
