/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UserPoolType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UserPoolTypeUnmarshaller implements Unmarshaller<UserPoolType, JsonUnmarshallerContext> {

    public UserPoolType unmarshall(JsonUnmarshallerContext context) throws Exception {
        UserPoolType.Builder userPoolTypeBuilder = UserPoolType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Policies", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.policies(UserPoolPolicyTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LambdaConfig", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.lambdaConfig(LambdaConfigTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.lastModifiedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("SchemaAttributes", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.schemaAttributes(new ListUnmarshaller<SchemaAttributeType>(
                            SchemaAttributeTypeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("AutoVerifiedAttributes", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.autoVerifiedAttributesWithStrings(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("AliasAttributes", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.aliasAttributesWithStrings(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("UsernameAttributes", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.usernameAttributesWithStrings(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SmsVerificationMessage", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.smsVerificationMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EmailVerificationMessage", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.emailVerificationMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EmailVerificationSubject", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.emailVerificationSubject(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VerificationMessageTemplate", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.verificationMessageTemplate(VerificationMessageTemplateTypeUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("SmsAuthenticationMessage", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.smsAuthenticationMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MfaConfiguration", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.mfaConfiguration(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeviceConfiguration", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder
                            .deviceConfiguration(DeviceConfigurationTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EstimatedNumberOfUsers", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.estimatedNumberOfUsers(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("EmailConfiguration", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.emailConfiguration(EmailConfigurationTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SmsConfiguration", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.smsConfiguration(SmsConfigurationTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("UserPoolTags", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.userPoolTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SmsConfigurationFailure", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.smsConfigurationFailure(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EmailConfigurationFailure", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.emailConfigurationFailure(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AdminCreateUserConfig", targetDepth)) {
                    context.nextToken();
                    userPoolTypeBuilder.adminCreateUserConfig(AdminCreateUserConfigTypeUnmarshaller.getInstance().unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return userPoolTypeBuilder.build();
    }

    private static final UserPoolTypeUnmarshaller INSTANCE = new UserPoolTypeUnmarshaller();

    public static UserPoolTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
