/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link VerificationMessageTemplateType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class VerificationMessageTemplateTypeMarshaller {
    private static final MarshallingInfo<String> SMSMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsMessage").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessage").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILSUBJECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailSubject").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILMESSAGEBYLINK_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessageByLink").isBinary(false).build();

    private static final MarshallingInfo<String> EMAILSUBJECTBYLINK_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailSubjectByLink").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTEMAILOPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultEmailOption").isBinary(false).build();

    private static final VerificationMessageTemplateTypeMarshaller INSTANCE = new VerificationMessageTemplateTypeMarshaller();

    private VerificationMessageTemplateTypeMarshaller() {
    }

    public static VerificationMessageTemplateTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(VerificationMessageTemplateType verificationMessageTemplateType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(verificationMessageTemplateType, "verificationMessageTemplateType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(verificationMessageTemplateType.smsMessage(), SMSMESSAGE_BINDING);
            protocolMarshaller.marshall(verificationMessageTemplateType.emailMessage(), EMAILMESSAGE_BINDING);
            protocolMarshaller.marshall(verificationMessageTemplateType.emailSubject(), EMAILSUBJECT_BINDING);
            protocolMarshaller.marshall(verificationMessageTemplateType.emailMessageByLink(), EMAILMESSAGEBYLINK_BINDING);
            protocolMarshaller.marshall(verificationMessageTemplateType.emailSubjectByLink(), EMAILSUBJECTBYLINK_BINDING);
            protocolMarshaller.marshall(verificationMessageTemplateType.defaultEmailOptionAsString(), DEFAULTEMAILOPTION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
