/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserConfigTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminCreateUserConfigType
implements StructuredPojo,
ToCopyableBuilder<Builder, AdminCreateUserConfigType> {
    private final Boolean allowAdminCreateUserOnly;
    private final Integer unusedAccountValidityDays;
    private final MessageTemplateType inviteMessageTemplate;

    private AdminCreateUserConfigType(BuilderImpl builder) {
        this.allowAdminCreateUserOnly = builder.allowAdminCreateUserOnly;
        this.unusedAccountValidityDays = builder.unusedAccountValidityDays;
        this.inviteMessageTemplate = builder.inviteMessageTemplate;
    }

    public Boolean allowAdminCreateUserOnly() {
        return this.allowAdminCreateUserOnly;
    }

    public Integer unusedAccountValidityDays() {
        return this.unusedAccountValidityDays;
    }

    public MessageTemplateType inviteMessageTemplate() {
        return this.inviteMessageTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowAdminCreateUserOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedAccountValidityDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteMessageTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserConfigType)) {
            return false;
        }
        AdminCreateUserConfigType other = (AdminCreateUserConfigType)obj;
        return Objects.equals(this.allowAdminCreateUserOnly(), other.allowAdminCreateUserOnly()) && Objects.equals(this.unusedAccountValidityDays(), other.unusedAccountValidityDays()) && Objects.equals(this.inviteMessageTemplate(), other.inviteMessageTemplate());
    }

    public String toString() {
        return ToString.builder((String)"AdminCreateUserConfigType").add("AllowAdminCreateUserOnly", (Object)this.allowAdminCreateUserOnly()).add("UnusedAccountValidityDays", (Object)this.unusedAccountValidityDays()).add("InviteMessageTemplate", (Object)this.inviteMessageTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowAdminCreateUserOnly": {
                return Optional.ofNullable(clazz.cast(this.allowAdminCreateUserOnly()));
            }
            case "UnusedAccountValidityDays": {
                return Optional.ofNullable(clazz.cast(this.unusedAccountValidityDays()));
            }
            case "InviteMessageTemplate": {
                return Optional.ofNullable(clazz.cast(this.inviteMessageTemplate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdminCreateUserConfigTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowAdminCreateUserOnly;
        private Integer unusedAccountValidityDays;
        private MessageTemplateType inviteMessageTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminCreateUserConfigType model) {
            this.allowAdminCreateUserOnly(model.allowAdminCreateUserOnly);
            this.unusedAccountValidityDays(model.unusedAccountValidityDays);
            this.inviteMessageTemplate(model.inviteMessageTemplate);
        }

        public final Boolean getAllowAdminCreateUserOnly() {
            return this.allowAdminCreateUserOnly;
        }

        @Override
        public final Builder allowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
            this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
            return this;
        }

        public final void setAllowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
            this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
        }

        public final Integer getUnusedAccountValidityDays() {
            return this.unusedAccountValidityDays;
        }

        @Override
        public final Builder unusedAccountValidityDays(Integer unusedAccountValidityDays) {
            this.unusedAccountValidityDays = unusedAccountValidityDays;
            return this;
        }

        public final void setUnusedAccountValidityDays(Integer unusedAccountValidityDays) {
            this.unusedAccountValidityDays = unusedAccountValidityDays;
        }

        public final MessageTemplateType.Builder getInviteMessageTemplate() {
            return this.inviteMessageTemplate != null ? this.inviteMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder inviteMessageTemplate(MessageTemplateType inviteMessageTemplate) {
            this.inviteMessageTemplate = inviteMessageTemplate;
            return this;
        }

        public final void setInviteMessageTemplate(MessageTemplateType.BuilderImpl inviteMessageTemplate) {
            this.inviteMessageTemplate = inviteMessageTemplate != null ? inviteMessageTemplate.build() : null;
        }

        public AdminCreateUserConfigType build() {
            return new AdminCreateUserConfigType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AdminCreateUserConfigType> {
        public Builder allowAdminCreateUserOnly(Boolean var1);

        public Builder unusedAccountValidityDays(Integer var1);

        public Builder inviteMessageTemplate(MessageTemplateType var1);

        default public Builder inviteMessageTemplate(Consumer<MessageTemplateType.Builder> inviteMessageTemplate) {
            return this.inviteMessageTemplate((MessageTemplateType)((MessageTemplateType.Builder)MessageTemplateType.builder().applyMutation(inviteMessageTemplate)).build());
        }
    }
}

