/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminDisableProviderForUserRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminDisableProviderForUserRequest> {
    private final String userPoolId;
    private final ProviderUserIdentifierType user;

    private AdminDisableProviderForUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.user = builder.user;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public ProviderUserIdentifierType user() {
        return this.user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminDisableProviderForUserRequest)) {
            return false;
        }
        AdminDisableProviderForUserRequest other = (AdminDisableProviderForUserRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.user(), other.user());
    }

    public String toString() {
        return ToString.builder((String)"AdminDisableProviderForUserRequest").add("UserPoolId", (Object)this.userPoolId()).add("User", (Object)this.user()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private ProviderUserIdentifierType user;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminDisableProviderForUserRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.user(model.user);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final ProviderUserIdentifierType.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(ProviderUserIdentifierType user) {
            this.user = user;
            return this;
        }

        public final void setUser(ProviderUserIdentifierType.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminDisableProviderForUserRequest build() {
            return new AdminDisableProviderForUserRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, AdminDisableProviderForUserRequest> {
        public Builder userPoolId(String var1);

        public Builder user(ProviderUserIdentifierType var1);

        default public Builder user(Consumer<ProviderUserIdentifierType.Builder> user) {
            return this.user((ProviderUserIdentifierType)((ProviderUserIdentifierType.Builder)ProviderUserIdentifierType.builder().applyMutation(user)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

