/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponsesTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminRespondToAuthChallengeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminRespondToAuthChallengeRequest> {
    private final String userPoolId;
    private final String clientId;
    private final String challengeName;
    private final Map<String, String> challengeResponses;
    private final String session;

    private AdminRespondToAuthChallengeRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.challengeName = builder.challengeName;
        this.challengeResponses = builder.challengeResponses;
        this.session = builder.session;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public String challengeNameAsString() {
        return this.challengeName;
    }

    public Map<String, String> challengeResponses() {
        return this.challengeResponses;
    }

    public String session() {
        return this.session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminRespondToAuthChallengeRequest)) {
            return false;
        }
        AdminRespondToAuthChallengeRequest other = (AdminRespondToAuthChallengeRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.challengeResponses(), other.challengeResponses()) && Objects.equals(this.session(), other.session());
    }

    public String toString() {
        return ToString.builder((String)"AdminRespondToAuthChallengeRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)this.clientId()).add("ChallengeName", (Object)this.challengeNameAsString()).add("ChallengeResponses", this.challengeResponses()).add("Session", (Object)this.session()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "ChallengeResponses": {
                return Optional.ofNullable(clazz.cast(this.challengeResponses()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private String challengeName;
        private Map<String, String> challengeResponses = DefaultSdkAutoConstructMap.getInstance();
        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminRespondToAuthChallengeRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.challengeName(model.challengeName);
            this.challengeResponses(model.challengeResponses);
            this.session(model.session);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName.toString());
            return this;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        public final Map<String, String> getChallengeResponses() {
            return this.challengeResponses;
        }

        @Override
        public final Builder challengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
            return this;
        }

        public final void setChallengeResponses(Map<String, String> challengeResponses) {
            this.challengeResponses = ChallengeResponsesTypeCopier.copy(challengeResponses);
        }

        public final String getSession() {
            return this.session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminRespondToAuthChallengeRequest build() {
            return new AdminRespondToAuthChallengeRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, AdminRespondToAuthChallengeRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder challengeResponses(Map<String, String> var1);

        public Builder session(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

