/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CodeDeliveryDetailsTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeDeliveryDetailsType
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeDeliveryDetailsType> {
    private final String destination;
    private final String deliveryMedium;
    private final String attributeName;

    private CodeDeliveryDetailsType(BuilderImpl builder) {
        this.destination = builder.destination;
        this.deliveryMedium = builder.deliveryMedium;
        this.attributeName = builder.attributeName;
    }

    public String destination() {
        return this.destination;
    }

    public DeliveryMediumType deliveryMedium() {
        return DeliveryMediumType.fromValue(this.deliveryMedium);
    }

    public String deliveryMediumAsString() {
        return this.deliveryMedium;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryMediumAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeDeliveryDetailsType)) {
            return false;
        }
        CodeDeliveryDetailsType other = (CodeDeliveryDetailsType)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.deliveryMediumAsString(), other.deliveryMediumAsString()) && Objects.equals(this.attributeName(), other.attributeName());
    }

    public String toString() {
        return ToString.builder((String)"CodeDeliveryDetailsType").add("Destination", (Object)this.destination()).add("DeliveryMedium", (Object)this.deliveryMediumAsString()).add("AttributeName", (Object)this.attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DeliveryMedium": {
                return Optional.ofNullable(clazz.cast(this.deliveryMediumAsString()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeDeliveryDetailsTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destination;
        private String deliveryMedium;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeDeliveryDetailsType model) {
            this.destination(model.destination);
            this.deliveryMedium(model.deliveryMedium);
            this.attributeName(model.attributeName);
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDeliveryMedium() {
            return this.deliveryMedium;
        }

        @Override
        public final Builder deliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
            return this;
        }

        @Override
        public final Builder deliveryMedium(DeliveryMediumType deliveryMedium) {
            this.deliveryMedium(deliveryMedium.toString());
            return this;
        }

        public final void setDeliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public CodeDeliveryDetailsType build() {
            return new CodeDeliveryDetailsType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeDeliveryDetailsType> {
        public Builder destination(String var1);

        public Builder deliveryMedium(String var1);

        public Builder deliveryMedium(DeliveryMediumType var1);

        public Builder attributeName(String var1);
    }
}

