/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfirmDeviceRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ConfirmDeviceRequest> {
    private final String accessToken;
    private final String deviceKey;
    private final DeviceSecretVerifierConfigType deviceSecretVerifierConfig;
    private final String deviceName;

    private ConfirmDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.deviceKey = builder.deviceKey;
        this.deviceSecretVerifierConfig = builder.deviceSecretVerifierConfig;
        this.deviceName = builder.deviceName;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String deviceKey() {
        return this.deviceKey;
    }

    public DeviceSecretVerifierConfigType deviceSecretVerifierConfig() {
        return this.deviceSecretVerifierConfig;
    }

    public String deviceName() {
        return this.deviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSecretVerifierConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmDeviceRequest)) {
            return false;
        }
        ConfirmDeviceRequest other = (ConfirmDeviceRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.deviceSecretVerifierConfig(), other.deviceSecretVerifierConfig()) && Objects.equals(this.deviceName(), other.deviceName());
    }

    public String toString() {
        return ToString.builder((String)"ConfirmDeviceRequest").add("AccessToken", (Object)this.accessToken()).add("DeviceKey", (Object)this.deviceKey()).add("DeviceSecretVerifierConfig", (Object)this.deviceSecretVerifierConfig()).add("DeviceName", (Object)this.deviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "DeviceSecretVerifierConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceSecretVerifierConfig()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String deviceKey;
        private DeviceSecretVerifierConfigType deviceSecretVerifierConfig;
        private String deviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmDeviceRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.deviceKey(model.deviceKey);
            this.deviceSecretVerifierConfig(model.deviceSecretVerifierConfig);
            this.deviceName(model.deviceName);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final DeviceSecretVerifierConfigType.Builder getDeviceSecretVerifierConfig() {
            return this.deviceSecretVerifierConfig != null ? this.deviceSecretVerifierConfig.toBuilder() : null;
        }

        @Override
        public final Builder deviceSecretVerifierConfig(DeviceSecretVerifierConfigType deviceSecretVerifierConfig) {
            this.deviceSecretVerifierConfig = deviceSecretVerifierConfig;
            return this;
        }

        public final void setDeviceSecretVerifierConfig(DeviceSecretVerifierConfigType.BuilderImpl deviceSecretVerifierConfig) {
            this.deviceSecretVerifierConfig = deviceSecretVerifierConfig != null ? deviceSecretVerifierConfig.build() : null;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmDeviceRequest build() {
            return new ConfirmDeviceRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, ConfirmDeviceRequest> {
        public Builder accessToken(String var1);

        public Builder deviceKey(String var1);

        public Builder deviceSecretVerifierConfig(DeviceSecretVerifierConfigType var1);

        default public Builder deviceSecretVerifierConfig(Consumer<DeviceSecretVerifierConfigType.Builder> deviceSecretVerifierConfig) {
            return this.deviceSecretVerifierConfig((DeviceSecretVerifierConfigType)((DeviceSecretVerifierConfigType.Builder)DeviceSecretVerifierConfigType.builder().applyMutation(deviceSecretVerifierConfig)).build());
        }

        public Builder deviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

