/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfirmForgotPasswordRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ConfirmForgotPasswordRequest> {
    private final String clientId;
    private final String secretHash;
    private final String username;
    private final String confirmationCode;
    private final String password;

    private ConfirmForgotPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.secretHash = builder.secretHash;
        this.username = builder.username;
        this.confirmationCode = builder.confirmationCode;
        this.password = builder.password;
    }

    public String clientId() {
        return this.clientId;
    }

    public String secretHash() {
        return this.secretHash;
    }

    public String username() {
        return this.username;
    }

    public String confirmationCode() {
        return this.confirmationCode;
    }

    public String password() {
        return this.password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmForgotPasswordRequest)) {
            return false;
        }
        ConfirmForgotPasswordRequest other = (ConfirmForgotPasswordRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.secretHash(), other.secretHash()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.confirmationCode(), other.confirmationCode()) && Objects.equals(this.password(), other.password());
    }

    public String toString() {
        return ToString.builder((String)"ConfirmForgotPasswordRequest").add("ClientId", (Object)this.clientId()).add("SecretHash", (Object)this.secretHash()).add("Username", (Object)this.username()).add("ConfirmationCode", (Object)this.confirmationCode()).add("Password", (Object)this.password()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "SecretHash": {
                return Optional.ofNullable(clazz.cast(this.secretHash()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "ConfirmationCode": {
                return Optional.ofNullable(clazz.cast(this.confirmationCode()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String secretHash;
        private String username;
        private String confirmationCode;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmForgotPasswordRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.secretHash(model.secretHash);
            this.username(model.username);
            this.confirmationCode(model.confirmationCode);
            this.password(model.password);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getSecretHash() {
            return this.secretHash;
        }

        @Override
        public final Builder secretHash(String secretHash) {
            this.secretHash = secretHash;
            return this;
        }

        public final void setSecretHash(String secretHash) {
            this.secretHash = secretHash;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getConfirmationCode() {
            return this.confirmationCode;
        }

        @Override
        public final Builder confirmationCode(String confirmationCode) {
            this.confirmationCode = confirmationCode;
            return this;
        }

        public final void setConfirmationCode(String confirmationCode) {
            this.confirmationCode = confirmationCode;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmForgotPasswordRequest build() {
            return new ConfirmForgotPasswordRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, ConfirmForgotPasswordRequest> {
        public Builder clientId(String var1);

        public Builder secretHash(String var1);

        public Builder username(String var1);

        public Builder confirmationCode(String var1);

        public Builder password(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

