/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DomainDescriptionTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainDescriptionType
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainDescriptionType> {
    private final String userPoolId;
    private final String awsAccountId;
    private final String domain;
    private final String s3Bucket;
    private final String cloudFrontDistribution;
    private final String version;
    private final String status;

    private DomainDescriptionType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsAccountId = builder.awsAccountId;
        this.domain = builder.domain;
        this.s3Bucket = builder.s3Bucket;
        this.cloudFrontDistribution = builder.cloudFrontDistribution;
        this.version = builder.version;
        this.status = builder.status;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String domain() {
        return this.domain;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String cloudFrontDistribution() {
        return this.cloudFrontDistribution;
    }

    public String version() {
        return this.version;
    }

    public DomainStatusType status() {
        return DomainStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescriptionType)) {
            return false;
        }
        DomainDescriptionType other = (DomainDescriptionType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.cloudFrontDistribution(), other.cloudFrontDistribution()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DomainDescriptionType").add("UserPoolId", (Object)this.userPoolId()).add("AWSAccountId", (Object)this.awsAccountId()).add("Domain", (Object)this.domain()).add("S3Bucket", (Object)this.s3Bucket()).add("CloudFrontDistribution", (Object)this.cloudFrontDistribution()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "AWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "CloudFrontDistribution": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontDistribution()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainDescriptionTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String awsAccountId;
        private String domain;
        private String s3Bucket;
        private String cloudFrontDistribution;
        private String version;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescriptionType model) {
            this.userPoolId(model.userPoolId);
            this.awsAccountId(model.awsAccountId);
            this.domain(model.domain);
            this.s3Bucket(model.s3Bucket);
            this.cloudFrontDistribution(model.cloudFrontDistribution);
            this.version(model.version);
            this.status(model.status);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getAWSAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAWSAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getCloudFrontDistribution() {
            return this.cloudFrontDistribution;
        }

        @Override
        public final Builder cloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
            return this;
        }

        public final void setCloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public DomainDescriptionType build() {
            return new DomainDescriptionType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainDescriptionType> {
        public Builder userPoolId(String var1);

        public Builder awsAccountId(String var1);

        public Builder domain(String var1);

        public Builder s3Bucket(String var1);

        public Builder cloudFrontDistribution(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatusType var1);
    }
}

