/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, GetDeviceRequest> {
    private final String deviceKey;
    private final String accessToken;

    private GetDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.deviceKey = builder.deviceKey;
        this.accessToken = builder.accessToken;
    }

    public String deviceKey() {
        return this.deviceKey;
    }

    public String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceRequest)) {
            return false;
        }
        GetDeviceRequest other = (GetDeviceRequest)((Object)obj);
        return Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDeviceRequest").add("DeviceKey", (Object)this.deviceKey()).add("AccessToken", (Object)this.accessToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String deviceKey;
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceRequest model) {
            super(model);
            this.deviceKey(model.deviceKey);
            this.accessToken(model.accessToken);
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeviceRequest build() {
            return new GetDeviceRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, GetDeviceRequest> {
        public Builder deviceKey(String var1);

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

