/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityProviderByIdentifierRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, GetIdentityProviderByIdentifierRequest> {
    private final String userPoolId;
    private final String idpIdentifier;

    private GetIdentityProviderByIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.idpIdentifier = builder.idpIdentifier;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String idpIdentifier() {
        return this.idpIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.idpIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityProviderByIdentifierRequest)) {
            return false;
        }
        GetIdentityProviderByIdentifierRequest other = (GetIdentityProviderByIdentifierRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.idpIdentifier(), other.idpIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"GetIdentityProviderByIdentifierRequest").add("UserPoolId", (Object)this.userPoolId()).add("IdpIdentifier", (Object)this.idpIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "IdpIdentifier": {
                return Optional.ofNullable(clazz.cast(this.idpIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String idpIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityProviderByIdentifierRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.idpIdentifier(model.idpIdentifier);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getIdpIdentifier() {
            return this.idpIdentifier;
        }

        @Override
        public final Builder idpIdentifier(String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
            return this;
        }

        public final void setIdpIdentifier(String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityProviderByIdentifierRequest build() {
            return new GetIdentityProviderByIdentifierRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, GetIdentityProviderByIdentifierRequest> {
        public Builder userPoolId(String var1);

        public Builder idpIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

