/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GroupTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupType
implements StructuredPojo,
ToCopyableBuilder<Builder, GroupType> {
    private final String groupName;
    private final String userPoolId;
    private final String description;
    private final String roleArn;
    private final Integer precedence;
    private final Instant lastModifiedDate;
    private final Instant creationDate;

    private GroupType(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.userPoolId = builder.userPoolId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.precedence = builder.precedence;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    public String groupName() {
        return this.groupName;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String description() {
        return this.description;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Integer precedence() {
        return this.precedence;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.precedence());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupType)) {
            return false;
        }
        GroupType other = (GroupType)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.precedence(), other.precedence()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"GroupType").add("GroupName", (Object)this.groupName()).add("UserPoolId", (Object)this.userPoolId()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("Precedence", (Object)this.precedence()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Precedence": {
                return Optional.ofNullable(clazz.cast(this.precedence()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String userPoolId;
        private String description;
        private String roleArn;
        private Integer precedence;
        private Instant lastModifiedDate;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupType model) {
            this.groupName(model.groupName);
            this.userPoolId(model.userPoolId);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.precedence(model.precedence);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getPrecedence() {
            return this.precedence;
        }

        @Override
        public final Builder precedence(Integer precedence) {
            this.precedence = precedence;
            return this;
        }

        public final void setPrecedence(Integer precedence) {
            this.precedence = precedence;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public GroupType build() {
            return new GroupType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GroupType> {
        public Builder groupName(String var1);

        public Builder userPoolId(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder precedence(Integer var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);
    }
}

