/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthParametersTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateAuthRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, InitiateAuthRequest> {
    private final String authFlow;
    private final Map<String, String> authParameters;
    private final Map<String, String> clientMetadata;
    private final String clientId;

    private InitiateAuthRequest(BuilderImpl builder) {
        super(builder);
        this.authFlow = builder.authFlow;
        this.authParameters = builder.authParameters;
        this.clientMetadata = builder.clientMetadata;
        this.clientId = builder.clientId;
    }

    public AuthFlowType authFlow() {
        return AuthFlowType.fromValue(this.authFlow);
    }

    public String authFlowAsString() {
        return this.authFlow;
    }

    public Map<String, String> authParameters() {
        return this.authParameters;
    }

    public Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    public String clientId() {
        return this.clientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authFlowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateAuthRequest)) {
            return false;
        }
        InitiateAuthRequest other = (InitiateAuthRequest)((Object)obj);
        return Objects.equals(this.authFlowAsString(), other.authFlowAsString()) && Objects.equals(this.authParameters(), other.authParameters()) && Objects.equals(this.clientMetadata(), other.clientMetadata()) && Objects.equals(this.clientId(), other.clientId());
    }

    public String toString() {
        return ToString.builder((String)"InitiateAuthRequest").add("AuthFlow", (Object)this.authFlowAsString()).add("AuthParameters", this.authParameters()).add("ClientMetadata", this.clientMetadata()).add("ClientId", (Object)this.clientId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthFlow": {
                return Optional.ofNullable(clazz.cast(this.authFlowAsString()));
            }
            case "AuthParameters": {
                return Optional.ofNullable(clazz.cast(this.authParameters()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String authFlow;
        private Map<String, String> authParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateAuthRequest model) {
            super(model);
            this.authFlow(model.authFlow);
            this.authParameters(model.authParameters);
            this.clientMetadata(model.clientMetadata);
            this.clientId(model.clientId);
        }

        public final String getAuthFlow() {
            return this.authFlow;
        }

        @Override
        public final Builder authFlow(String authFlow) {
            this.authFlow = authFlow;
            return this;
        }

        @Override
        public final Builder authFlow(AuthFlowType authFlow) {
            this.authFlow(authFlow.toString());
            return this;
        }

        public final void setAuthFlow(String authFlow) {
            this.authFlow = authFlow;
        }

        public final Map<String, String> getAuthParameters() {
            return this.authParameters;
        }

        @Override
        public final Builder authParameters(Map<String, String> authParameters) {
            this.authParameters = AuthParametersTypeCopier.copy(authParameters);
            return this;
        }

        public final void setAuthParameters(Map<String, String> authParameters) {
            this.authParameters = AuthParametersTypeCopier.copy(authParameters);
        }

        public final Map<String, String> getClientMetadata() {
            return this.clientMetadata;
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitiateAuthRequest build() {
            return new InitiateAuthRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, InitiateAuthRequest> {
        public Builder authFlow(String var1);

        public Builder authFlow(AuthFlowType var1);

        public Builder authParameters(Map<String, String> var1);

        public Builder clientMetadata(Map<String, String> var1);

        public Builder clientId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

