/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeParametersTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateAuthResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, InitiateAuthResponse> {
    private final String challengeName;
    private final String session;
    private final Map<String, String> challengeParameters;
    private final AuthenticationResultType authenticationResult;

    private InitiateAuthResponse(BuilderImpl builder) {
        super(builder);
        this.challengeName = builder.challengeName;
        this.session = builder.session;
        this.challengeParameters = builder.challengeParameters;
        this.authenticationResult = builder.authenticationResult;
    }

    public ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public String challengeNameAsString() {
        return this.challengeName;
    }

    public String session() {
        return this.session;
    }

    public Map<String, String> challengeParameters() {
        return this.challengeParameters;
    }

    public AuthenticationResultType authenticationResult() {
        return this.authenticationResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateAuthResponse)) {
            return false;
        }
        InitiateAuthResponse other = (InitiateAuthResponse)((Object)obj);
        return Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.challengeParameters(), other.challengeParameters()) && Objects.equals(this.authenticationResult(), other.authenticationResult());
    }

    public String toString() {
        return ToString.builder((String)"InitiateAuthResponse").add("ChallengeName", (Object)this.challengeNameAsString()).add("Session", (Object)this.session()).add("ChallengeParameters", this.challengeParameters()).add("AuthenticationResult", (Object)this.authenticationResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "ChallengeParameters": {
                return Optional.ofNullable(clazz.cast(this.challengeParameters()));
            }
            case "AuthenticationResult": {
                return Optional.ofNullable(clazz.cast(this.authenticationResult()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String challengeName;
        private String session;
        private Map<String, String> challengeParameters = DefaultSdkAutoConstructMap.getInstance();
        private AuthenticationResultType authenticationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateAuthResponse model) {
            super(model);
            this.challengeName(model.challengeName);
            this.session(model.session);
            this.challengeParameters(model.challengeParameters);
            this.authenticationResult(model.authenticationResult);
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName.toString());
            return this;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        public final String getSession() {
            return this.session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        public final Map<String, String> getChallengeParameters() {
            return this.challengeParameters;
        }

        @Override
        public final Builder challengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
            return this;
        }

        public final void setChallengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
        }

        public final AuthenticationResultType.Builder getAuthenticationResult() {
            return this.authenticationResult != null ? this.authenticationResult.toBuilder() : null;
        }

        @Override
        public final Builder authenticationResult(AuthenticationResultType authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public final void setAuthenticationResult(AuthenticationResultType.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        public InitiateAuthResponse build() {
            return new InitiateAuthResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, InitiateAuthResponse> {
        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder session(String var1);

        public Builder challengeParameters(Map<String, String> var1);

        public Builder authenticationResult(AuthenticationResultType var1);

        default public Builder authenticationResult(Consumer<AuthenticationResultType.Builder> authenticationResult) {
            return this.authenticationResult((AuthenticationResultType)((AuthenticationResultType.Builder)AuthenticationResultType.builder().applyMutation(authenticationResult)).build());
        }
    }
}

