/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ListDevicesRequest> {
    private final String accessToken;
    private final Integer limit;
    private final String paginationToken;

    private ListDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.limit = builder.limit;
        this.paginationToken = builder.paginationToken;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesRequest)) {
            return false;
        }
        ListDevicesRequest other = (ListDevicesRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDevicesRequest").add("AccessToken", (Object)this.accessToken()).add("Limit", (Object)this.limit()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private Integer limit;
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.limit(model.limit);
            this.paginationToken(model.paginationToken);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicesRequest build() {
            return new ListDevicesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, ListDevicesRequest> {
        public Builder accessToken(String var1);

        public Builder limit(Integer var1);

        public Builder paginationToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

