/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProvidersListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityProvidersResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListIdentityProvidersResponse> {
    private final List<ProviderDescription> providers;
    private final String nextToken;

    private ListIdentityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.providers = builder.providers;
        this.nextToken = builder.nextToken;
    }

    public List<ProviderDescription> providers() {
        return this.providers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProvidersResponse)) {
            return false;
        }
        ListIdentityProvidersResponse other = (ListIdentityProvidersResponse)((Object)obj);
        return Objects.equals(this.providers(), other.providers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIdentityProvidersResponse").add("Providers", this.providers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Providers": {
                return Optional.ofNullable(clazz.cast(this.providers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<ProviderDescription> providers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProvidersResponse model) {
            super(model);
            this.providers(model.providers);
            this.nextToken(model.nextToken);
        }

        public final Collection<ProviderDescription.Builder> getProviders() {
            return this.providers != null ? (Collection)this.providers.stream().map(ProviderDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder providers(Collection<ProviderDescription> providers) {
            this.providers = ProvidersListTypeCopier.copy(providers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providers(ProviderDescription ... providers) {
            this.providers(Arrays.asList(providers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providers(Consumer<ProviderDescription.Builder> ... providers) {
            this.providers(Stream.of(providers).map(c -> (ProviderDescription)((ProviderDescription.Builder)ProviderDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProviders(Collection<ProviderDescription.BuilderImpl> providers) {
            this.providers = ProvidersListTypeCopier.copyFromBuilder(providers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityProvidersResponse build() {
            return new ListIdentityProvidersResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, ListIdentityProvidersResponse> {
        public Builder providers(Collection<ProviderDescription> var1);

        public Builder providers(ProviderDescription ... var1);

        public Builder providers(Consumer<ProviderDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

