/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobsListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserImportJobsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListUserImportJobsResponse> {
    private final List<UserImportJobType> userImportJobs;
    private final String paginationToken;

    private ListUserImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.userImportJobs = builder.userImportJobs;
        this.paginationToken = builder.paginationToken;
    }

    public List<UserImportJobType> userImportJobs() {
        return this.userImportJobs;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userImportJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserImportJobsResponse)) {
            return false;
        }
        ListUserImportJobsResponse other = (ListUserImportJobsResponse)((Object)obj);
        return Objects.equals(this.userImportJobs(), other.userImportJobs()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public String toString() {
        return ToString.builder((String)"ListUserImportJobsResponse").add("UserImportJobs", this.userImportJobs()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserImportJobs": {
                return Optional.ofNullable(clazz.cast(this.userImportJobs()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<UserImportJobType> userImportJobs = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserImportJobsResponse model) {
            super(model);
            this.userImportJobs(model.userImportJobs);
            this.paginationToken(model.paginationToken);
        }

        public final Collection<UserImportJobType.Builder> getUserImportJobs() {
            return this.userImportJobs != null ? (Collection)this.userImportJobs.stream().map(UserImportJobType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userImportJobs(Collection<UserImportJobType> userImportJobs) {
            this.userImportJobs = UserImportJobsListTypeCopier.copy(userImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userImportJobs(UserImportJobType ... userImportJobs) {
            this.userImportJobs(Arrays.asList(userImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userImportJobs(Consumer<UserImportJobType.Builder> ... userImportJobs) {
            this.userImportJobs(Stream.of(userImportJobs).map(c -> (UserImportJobType)((UserImportJobType.Builder)UserImportJobType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserImportJobs(Collection<UserImportJobType.BuilderImpl> userImportJobs) {
            this.userImportJobs = UserImportJobsListTypeCopier.copyFromBuilder(userImportJobs);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public ListUserImportJobsResponse build() {
            return new ListUserImportJobsResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, ListUserImportJobsResponse> {
        public Builder userImportJobs(Collection<UserImportJobType> var1);

        public Builder userImportJobs(UserImportJobType ... var1);

        public Builder userImportJobs(Consumer<UserImportJobType.Builder> ... var1);

        public Builder paginationToken(String var1);
    }
}

