/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsersListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListUsersResponse> {
    private final List<UserType> users;
    private final String paginationToken;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.paginationToken = builder.paginationToken;
    }

    public List<UserType> users() {
        return this.users;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse)((Object)obj);
        return Objects.equals(this.users(), other.users()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public String toString() {
        return ToString.builder((String)"ListUsersResponse").add("Users", this.users()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<UserType> users = DefaultSdkAutoConstructList.getInstance();
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            this.users(model.users);
            this.paginationToken(model.paginationToken);
        }

        public final Collection<UserType.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(UserType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserType> users) {
            this.users = UsersListTypeCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserType ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserType.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserType)((UserType.Builder)UserType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserType.BuilderImpl> users) {
            this.users = UsersListTypeCopier.copyFromBuilder(users);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, ListUsersResponse> {
        public Builder users(Collection<UserType> var1);

        public Builder users(UserType ... var1);

        public Builder users(Consumer<UserType.Builder> ... var1);

        public Builder paginationToken(String var1);
    }
}

