/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeliveryMediumType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.MFAOptionTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MFAOptionType
implements StructuredPojo,
ToCopyableBuilder<Builder, MFAOptionType> {
    private final String deliveryMedium;
    private final String attributeName;

    private MFAOptionType(BuilderImpl builder) {
        this.deliveryMedium = builder.deliveryMedium;
        this.attributeName = builder.attributeName;
    }

    public DeliveryMediumType deliveryMedium() {
        return DeliveryMediumType.fromValue(this.deliveryMedium);
    }

    public String deliveryMediumAsString() {
        return this.deliveryMedium;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryMediumAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFAOptionType)) {
            return false;
        }
        MFAOptionType other = (MFAOptionType)obj;
        return Objects.equals(this.deliveryMediumAsString(), other.deliveryMediumAsString()) && Objects.equals(this.attributeName(), other.attributeName());
    }

    public String toString() {
        return ToString.builder((String)"MFAOptionType").add("DeliveryMedium", (Object)this.deliveryMediumAsString()).add("AttributeName", (Object)this.attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryMedium": {
                return Optional.ofNullable(clazz.cast(this.deliveryMediumAsString()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MFAOptionTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryMedium;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(MFAOptionType model) {
            this.deliveryMedium(model.deliveryMedium);
            this.attributeName(model.attributeName);
        }

        public final String getDeliveryMedium() {
            return this.deliveryMedium;
        }

        @Override
        public final Builder deliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
            return this;
        }

        @Override
        public final Builder deliveryMedium(DeliveryMediumType deliveryMedium) {
            this.deliveryMedium(deliveryMedium.toString());
            return this;
        }

        public final void setDeliveryMedium(String deliveryMedium) {
            this.deliveryMedium = deliveryMedium;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public MFAOptionType build() {
            return new MFAOptionType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MFAOptionType> {
        public Builder deliveryMedium(String var1);

        public Builder deliveryMedium(DeliveryMediumType var1);

        public Builder attributeName(String var1);
    }
}

