/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.NewDeviceMetadataTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewDeviceMetadataType
implements StructuredPojo,
ToCopyableBuilder<Builder, NewDeviceMetadataType> {
    private final String deviceKey;
    private final String deviceGroupKey;

    private NewDeviceMetadataType(BuilderImpl builder) {
        this.deviceKey = builder.deviceKey;
        this.deviceGroupKey = builder.deviceGroupKey;
    }

    public String deviceKey() {
        return this.deviceKey;
    }

    public String deviceGroupKey() {
        return this.deviceGroupKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceGroupKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewDeviceMetadataType)) {
            return false;
        }
        NewDeviceMetadataType other = (NewDeviceMetadataType)obj;
        return Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.deviceGroupKey(), other.deviceGroupKey());
    }

    public String toString() {
        return ToString.builder((String)"NewDeviceMetadataType").add("DeviceKey", (Object)this.deviceKey()).add("DeviceGroupKey", (Object)this.deviceGroupKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "DeviceGroupKey": {
                return Optional.ofNullable(clazz.cast(this.deviceGroupKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewDeviceMetadataTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceKey;
        private String deviceGroupKey;

        private BuilderImpl() {
        }

        private BuilderImpl(NewDeviceMetadataType model) {
            this.deviceKey(model.deviceKey);
            this.deviceGroupKey(model.deviceGroupKey);
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final String getDeviceGroupKey() {
            return this.deviceGroupKey;
        }

        @Override
        public final Builder deviceGroupKey(String deviceGroupKey) {
            this.deviceGroupKey = deviceGroupKey;
            return this;
        }

        public final void setDeviceGroupKey(String deviceGroupKey) {
            this.deviceGroupKey = deviceGroupKey;
        }

        public NewDeviceMetadataType build() {
            return new NewDeviceMetadataType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NewDeviceMetadataType> {
        public Builder deviceKey(String var1);

        public Builder deviceGroupKey(String var1);
    }
}

