/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.PasswordPolicyTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PasswordPolicyType
implements StructuredPojo,
ToCopyableBuilder<Builder, PasswordPolicyType> {
    private final Integer minimumLength;
    private final Boolean requireUppercase;
    private final Boolean requireLowercase;
    private final Boolean requireNumbers;
    private final Boolean requireSymbols;

    private PasswordPolicyType(BuilderImpl builder) {
        this.minimumLength = builder.minimumLength;
        this.requireUppercase = builder.requireUppercase;
        this.requireLowercase = builder.requireLowercase;
        this.requireNumbers = builder.requireNumbers;
        this.requireSymbols = builder.requireSymbols;
    }

    public Integer minimumLength() {
        return this.minimumLength;
    }

    public Boolean requireUppercase() {
        return this.requireUppercase;
    }

    public Boolean requireLowercase() {
        return this.requireLowercase;
    }

    public Boolean requireNumbers() {
        return this.requireNumbers;
    }

    public Boolean requireSymbols() {
        return this.requireSymbols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireSymbols());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicyType)) {
            return false;
        }
        PasswordPolicyType other = (PasswordPolicyType)obj;
        return Objects.equals(this.minimumLength(), other.minimumLength()) && Objects.equals(this.requireUppercase(), other.requireUppercase()) && Objects.equals(this.requireLowercase(), other.requireLowercase()) && Objects.equals(this.requireNumbers(), other.requireNumbers()) && Objects.equals(this.requireSymbols(), other.requireSymbols());
    }

    public String toString() {
        return ToString.builder((String)"PasswordPolicyType").add("MinimumLength", (Object)this.minimumLength()).add("RequireUppercase", (Object)this.requireUppercase()).add("RequireLowercase", (Object)this.requireLowercase()).add("RequireNumbers", (Object)this.requireNumbers()).add("RequireSymbols", (Object)this.requireSymbols()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumLength": {
                return Optional.ofNullable(clazz.cast(this.minimumLength()));
            }
            case "RequireUppercase": {
                return Optional.ofNullable(clazz.cast(this.requireUppercase()));
            }
            case "RequireLowercase": {
                return Optional.ofNullable(clazz.cast(this.requireLowercase()));
            }
            case "RequireNumbers": {
                return Optional.ofNullable(clazz.cast(this.requireNumbers()));
            }
            case "RequireSymbols": {
                return Optional.ofNullable(clazz.cast(this.requireSymbols()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PasswordPolicyTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumLength;
        private Boolean requireUppercase;
        private Boolean requireLowercase;
        private Boolean requireNumbers;
        private Boolean requireSymbols;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicyType model) {
            this.minimumLength(model.minimumLength);
            this.requireUppercase(model.requireUppercase);
            this.requireLowercase(model.requireLowercase);
            this.requireNumbers(model.requireNumbers);
            this.requireSymbols(model.requireSymbols);
        }

        public final Integer getMinimumLength() {
            return this.minimumLength;
        }

        @Override
        public final Builder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final void setMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
        }

        public final Boolean getRequireUppercase() {
            return this.requireUppercase;
        }

        @Override
        public final Builder requireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        public final void setRequireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
        }

        public final Boolean getRequireLowercase() {
            return this.requireLowercase;
        }

        @Override
        public final Builder requireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        public final void setRequireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
        }

        public final Boolean getRequireNumbers() {
            return this.requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireSymbols() {
            return this.requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        public PasswordPolicyType build() {
            return new PasswordPolicyType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PasswordPolicyType> {
        public Builder minimumLength(Integer var1);

        public Builder requireUppercase(Boolean var1);

        public Builder requireLowercase(Boolean var1);

        public Builder requireNumbers(Boolean var1);

        public Builder requireSymbols(Boolean var1);
    }
}

