/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResourceServerScopeTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceServerScopeType
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceServerScopeType> {
    private final String scopeName;
    private final String scopeDescription;

    private ResourceServerScopeType(BuilderImpl builder) {
        this.scopeName = builder.scopeName;
        this.scopeDescription = builder.scopeDescription;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public String scopeDescription() {
        return this.scopeDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerScopeType)) {
            return false;
        }
        ResourceServerScopeType other = (ResourceServerScopeType)obj;
        return Objects.equals(this.scopeName(), other.scopeName()) && Objects.equals(this.scopeDescription(), other.scopeDescription());
    }

    public String toString() {
        return ToString.builder((String)"ResourceServerScopeType").add("ScopeName", (Object)this.scopeName()).add("ScopeDescription", (Object)this.scopeDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScopeName": {
                return Optional.ofNullable(clazz.cast(this.scopeName()));
            }
            case "ScopeDescription": {
                return Optional.ofNullable(clazz.cast(this.scopeDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceServerScopeTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String scopeName;
        private String scopeDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceServerScopeType model) {
            this.scopeName(model.scopeName);
            this.scopeDescription(model.scopeDescription);
        }

        public final String getScopeName() {
            return this.scopeName;
        }

        @Override
        public final Builder scopeName(String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        public final void setScopeName(String scopeName) {
            this.scopeName = scopeName;
        }

        public final String getScopeDescription() {
            return this.scopeDescription;
        }

        @Override
        public final Builder scopeDescription(String scopeDescription) {
            this.scopeDescription = scopeDescription;
            return this;
        }

        public final void setScopeDescription(String scopeDescription) {
            this.scopeDescription = scopeDescription;
        }

        public ResourceServerScopeType build() {
            return new ResourceServerScopeType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceServerScopeType> {
        public Builder scopeName(String var1);

        public Builder scopeDescription(String var1);
    }
}

