/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UICustomizationTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UICustomizationType
implements StructuredPojo,
ToCopyableBuilder<Builder, UICustomizationType> {
    private final String userPoolId;
    private final String clientId;
    private final String imageUrl;
    private final String css;
    private final String cssVersion;
    private final Instant lastModifiedDate;
    private final Instant creationDate;

    private UICustomizationType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.imageUrl = builder.imageUrl;
        this.css = builder.css;
        this.cssVersion = builder.cssVersion;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String imageUrl() {
        return this.imageUrl;
    }

    public String css() {
        return this.css;
    }

    public String cssVersion() {
        return this.cssVersion;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.css());
        hashCode = 31 * hashCode + Objects.hashCode(this.cssVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UICustomizationType)) {
            return false;
        }
        UICustomizationType other = (UICustomizationType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.css(), other.css()) && Objects.equals(this.cssVersion(), other.cssVersion()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"UICustomizationType").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)this.clientId()).add("ImageUrl", (Object)this.imageUrl()).add("CSS", (Object)this.css()).add("CSSVersion", (Object)this.cssVersion()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ImageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "CSS": {
                return Optional.ofNullable(clazz.cast(this.css()));
            }
            case "CSSVersion": {
                return Optional.ofNullable(clazz.cast(this.cssVersion()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UICustomizationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private String imageUrl;
        private String css;
        private String cssVersion;
        private Instant lastModifiedDate;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UICustomizationType model) {
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.imageUrl(model.imageUrl);
            this.css(model.css);
            this.cssVersion(model.cssVersion);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getCSS() {
            return this.css;
        }

        @Override
        public final Builder css(String css) {
            this.css = css;
            return this;
        }

        public final void setCSS(String css) {
            this.css = css;
        }

        public final String getCSSVersion() {
            return this.cssVersion;
        }

        @Override
        public final Builder cssVersion(String cssVersion) {
            this.cssVersion = cssVersion;
            return this;
        }

        public final void setCSSVersion(String cssVersion) {
            this.cssVersion = cssVersion;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public UICustomizationType build() {
            return new UICustomizationType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UICustomizationType> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder imageUrl(String var1);

        public Builder css(String var1);

        public Builder cssVersion(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);
    }
}

