/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeMappingTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdpIdentifiersListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDetailsTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIdentityProviderRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateIdentityProviderRequest> {
    private final String userPoolId;
    private final String providerName;
    private final Map<String, String> providerDetails;
    private final Map<String, String> attributeMapping;
    private final List<String> idpIdentifiers;

    private UpdateIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.providerName = builder.providerName;
        this.providerDetails = builder.providerDetails;
        this.attributeMapping = builder.attributeMapping;
        this.idpIdentifiers = builder.idpIdentifiers;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String providerName() {
        return this.providerName;
    }

    public Map<String, String> providerDetails() {
        return this.providerDetails;
    }

    public Map<String, String> attributeMapping() {
        return this.attributeMapping;
    }

    public List<String> idpIdentifiers() {
        return this.idpIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.idpIdentifiers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityProviderRequest)) {
            return false;
        }
        UpdateIdentityProviderRequest other = (UpdateIdentityProviderRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerDetails(), other.providerDetails()) && Objects.equals(this.attributeMapping(), other.attributeMapping()) && Objects.equals(this.idpIdentifiers(), other.idpIdentifiers());
    }

    public String toString() {
        return ToString.builder((String)"UpdateIdentityProviderRequest").add("UserPoolId", (Object)this.userPoolId()).add("ProviderName", (Object)this.providerName()).add("ProviderDetails", this.providerDetails()).add("AttributeMapping", this.attributeMapping()).add("IdpIdentifiers", this.idpIdentifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "ProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.providerDetails()));
            }
            case "AttributeMapping": {
                return Optional.ofNullable(clazz.cast(this.attributeMapping()));
            }
            case "IdpIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.idpIdentifiers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String providerName;
        private Map<String, String> providerDetails = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> attributeMapping = DefaultSdkAutoConstructMap.getInstance();
        private List<String> idpIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityProviderRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.providerName(model.providerName);
            this.providerDetails(model.providerDetails);
            this.attributeMapping(model.attributeMapping);
            this.idpIdentifiers(model.idpIdentifiers);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Map<String, String> getProviderDetails() {
            return this.providerDetails;
        }

        @Override
        public final Builder providerDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
            return this;
        }

        public final void setProviderDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
        }

        public final Map<String, String> getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        public final Builder attributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
            return this;
        }

        public final void setAttributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
        }

        public final Collection<String> getIdpIdentifiers() {
            return this.idpIdentifiers;
        }

        @Override
        public final Builder idpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idpIdentifiers(String ... idpIdentifiers) {
            this.idpIdentifiers(Arrays.asList(idpIdentifiers));
            return this;
        }

        public final void setIdpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityProviderRequest build() {
            return new UpdateIdentityProviderRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, UpdateIdentityProviderRequest> {
        public Builder userPoolId(String var1);

        public Builder providerName(String var1);

        public Builder providerDetails(Map<String, String> var1);

        public Builder attributeMapping(Map<String, String> var1);

        public Builder idpIdentifiers(Collection<String> var1);

        public Builder idpIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

