/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolMfaType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTagsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserPoolRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateUserPoolRequest> {
    private final String userPoolId;
    private final UserPoolPolicyType policies;
    private final LambdaConfigType lambdaConfig;
    private final List<String> autoVerifiedAttributes;
    private final String smsVerificationMessage;
    private final String emailVerificationMessage;
    private final String emailVerificationSubject;
    private final VerificationMessageTemplateType verificationMessageTemplate;
    private final String smsAuthenticationMessage;
    private final String mfaConfiguration;
    private final DeviceConfigurationType deviceConfiguration;
    private final EmailConfigurationType emailConfiguration;
    private final SmsConfigurationType smsConfiguration;
    private final Map<String, String> userPoolTags;
    private final AdminCreateUserConfigType adminCreateUserConfig;

    private UpdateUserPoolRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.policies = builder.policies;
        this.lambdaConfig = builder.lambdaConfig;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public UserPoolPolicyType policies() {
        return this.policies;
    }

    public LambdaConfigType lambdaConfig() {
        return this.lambdaConfig;
    }

    public List<VerifiedAttributeType> autoVerifiedAttributes() {
        return TypeConverter.convert(this.autoVerifiedAttributes, VerifiedAttributeType::fromValue);
    }

    public List<String> autoVerifiedAttributesAsStrings() {
        return this.autoVerifiedAttributes;
    }

    public String smsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public String emailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public String emailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public VerificationMessageTemplateType verificationMessageTemplate() {
        return this.verificationMessageTemplate;
    }

    public String smsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(this.mfaConfiguration);
    }

    public String mfaConfigurationAsString() {
        return this.mfaConfiguration;
    }

    public DeviceConfigurationType deviceConfiguration() {
        return this.deviceConfiguration;
    }

    public EmailConfigurationType emailConfiguration() {
        return this.emailConfiguration;
    }

    public SmsConfigurationType smsConfiguration() {
        return this.smsConfiguration;
    }

    public Map<String, String> userPoolTags() {
        return this.userPoolTags;
    }

    public AdminCreateUserConfigType adminCreateUserConfig() {
        return this.adminCreateUserConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoVerifiedAttributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminCreateUserConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolRequest)) {
            return false;
        }
        UpdateUserPoolRequest other = (UpdateUserPoolRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && Objects.equals(this.autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings()) && Objects.equals(this.smsVerificationMessage(), other.smsVerificationMessage()) && Objects.equals(this.emailVerificationMessage(), other.emailVerificationMessage()) && Objects.equals(this.emailVerificationSubject(), other.emailVerificationSubject()) && Objects.equals(this.verificationMessageTemplate(), other.verificationMessageTemplate()) && Objects.equals(this.smsAuthenticationMessage(), other.smsAuthenticationMessage()) && Objects.equals(this.mfaConfigurationAsString(), other.mfaConfigurationAsString()) && Objects.equals(this.deviceConfiguration(), other.deviceConfiguration()) && Objects.equals(this.emailConfiguration(), other.emailConfiguration()) && Objects.equals(this.smsConfiguration(), other.smsConfiguration()) && Objects.equals(this.userPoolTags(), other.userPoolTags()) && Objects.equals(this.adminCreateUserConfig(), other.adminCreateUserConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserPoolRequest").add("UserPoolId", (Object)this.userPoolId()).add("Policies", (Object)this.policies()).add("LambdaConfig", (Object)this.lambdaConfig()).add("AutoVerifiedAttributes", this.autoVerifiedAttributesAsStrings()).add("SmsVerificationMessage", (Object)this.smsVerificationMessage()).add("EmailVerificationMessage", (Object)this.emailVerificationMessage()).add("EmailVerificationSubject", (Object)this.emailVerificationSubject()).add("VerificationMessageTemplate", (Object)this.verificationMessageTemplate()).add("SmsAuthenticationMessage", (Object)this.smsAuthenticationMessage()).add("MfaConfiguration", (Object)this.mfaConfigurationAsString()).add("DeviceConfiguration", (Object)this.deviceConfiguration()).add("EmailConfiguration", (Object)this.emailConfiguration()).add("SmsConfiguration", (Object)this.smsConfiguration()).add("UserPoolTags", this.userPoolTags()).add("AdminCreateUserConfig", (Object)this.adminCreateUserConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "LambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
            case "AutoVerifiedAttributes": {
                return Optional.ofNullable(clazz.cast(this.autoVerifiedAttributesAsStrings()));
            }
            case "SmsVerificationMessage": {
                return Optional.ofNullable(clazz.cast(this.smsVerificationMessage()));
            }
            case "EmailVerificationMessage": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationMessage()));
            }
            case "EmailVerificationSubject": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationSubject()));
            }
            case "VerificationMessageTemplate": {
                return Optional.ofNullable(clazz.cast(this.verificationMessageTemplate()));
            }
            case "SmsAuthenticationMessage": {
                return Optional.ofNullable(clazz.cast(this.smsAuthenticationMessage()));
            }
            case "MfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mfaConfigurationAsString()));
            }
            case "DeviceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deviceConfiguration()));
            }
            case "EmailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.emailConfiguration()));
            }
            case "SmsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smsConfiguration()));
            }
            case "UserPoolTags": {
                return Optional.ofNullable(clazz.cast(this.userPoolTags()));
            }
            case "AdminCreateUserConfig": {
                return Optional.ofNullable(clazz.cast(this.adminCreateUserConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private UserPoolPolicyType policies;
        private LambdaConfigType lambdaConfig;
        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();
        private String smsVerificationMessage;
        private String emailVerificationMessage;
        private String emailVerificationSubject;
        private VerificationMessageTemplateType verificationMessageTemplate;
        private String smsAuthenticationMessage;
        private String mfaConfiguration;
        private DeviceConfigurationType deviceConfiguration;
        private EmailConfigurationType emailConfiguration;
        private SmsConfigurationType smsConfiguration;
        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();
        private AdminCreateUserConfigType adminCreateUserConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.policies(model.policies);
            this.lambdaConfig(model.lambdaConfig);
            this.autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            this.smsVerificationMessage(model.smsVerificationMessage);
            this.emailVerificationMessage(model.emailVerificationMessage);
            this.emailVerificationSubject(model.emailVerificationSubject);
            this.verificationMessageTemplate(model.verificationMessageTemplate);
            this.smsAuthenticationMessage(model.smsAuthenticationMessage);
            this.mfaConfiguration(model.mfaConfiguration);
            this.deviceConfiguration(model.deviceConfiguration);
            this.emailConfiguration(model.emailConfiguration);
            this.smsConfiguration(model.smsConfiguration);
            this.userPoolTags(model.userPoolTags);
            this.adminCreateUserConfig(model.adminCreateUserConfig);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return this.policies != null ? this.policies.toBuilder() : null;
        }

        @Override
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final Collection<String> getAutoVerifiedAttributes() {
            return this.autoVerifiedAttributes;
        }

        @Override
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String ... autoVerifiedAttributes) {
            this.autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
            this.autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        public final String getSmsVerificationMessage() {
            return this.smsVerificationMessage;
        }

        @Override
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        public final String getEmailVerificationMessage() {
            return this.emailVerificationMessage;
        }

        @Override
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        public final String getEmailVerificationSubject() {
            return this.emailVerificationSubject;
        }

        @Override
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return this.verificationMessageTemplate != null ? this.verificationMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        public final String getSmsAuthenticationMessage() {
            return this.smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        public final String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration.toString());
            return this;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return this.deviceConfiguration != null ? this.deviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return this.emailConfiguration != null ? this.emailConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return this.smsConfiguration != null ? this.smsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        public final Map<String, String> getUserPoolTags() {
            return this.userPoolTags;
        }

        @Override
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return this.adminCreateUserConfig != null ? this.adminCreateUserConfig.toBuilder() : null;
        }

        @Override
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPoolRequest build() {
            return new UpdateUserPoolRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, UpdateUserPoolRequest> {
        public Builder userPoolId(String var1);

        public Builder policies(UserPoolPolicyType var1);

        default public Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return this.policies((UserPoolPolicyType)((UserPoolPolicyType.Builder)UserPoolPolicyType.builder().applyMutation(policies)).build());
        }

        public Builder lambdaConfig(LambdaConfigType var1);

        default public Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaConfigType)((LambdaConfigType.Builder)LambdaConfigType.builder().applyMutation(lambdaConfig)).build());
        }

        public Builder autoVerifiedAttributesWithStrings(Collection<String> var1);

        public Builder autoVerifiedAttributesWithStrings(String ... var1);

        public Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> var1);

        public Builder autoVerifiedAttributes(VerifiedAttributeType ... var1);

        public Builder smsVerificationMessage(String var1);

        public Builder emailVerificationMessage(String var1);

        public Builder emailVerificationSubject(String var1);

        public Builder verificationMessageTemplate(VerificationMessageTemplateType var1);

        default public Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return this.verificationMessageTemplate((VerificationMessageTemplateType)((VerificationMessageTemplateType.Builder)VerificationMessageTemplateType.builder().applyMutation(verificationMessageTemplate)).build());
        }

        public Builder smsAuthenticationMessage(String var1);

        public Builder mfaConfiguration(String var1);

        public Builder mfaConfiguration(UserPoolMfaType var1);

        public Builder deviceConfiguration(DeviceConfigurationType var1);

        default public Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return this.deviceConfiguration((DeviceConfigurationType)((DeviceConfigurationType.Builder)DeviceConfigurationType.builder().applyMutation(deviceConfiguration)).build());
        }

        public Builder emailConfiguration(EmailConfigurationType var1);

        default public Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return this.emailConfiguration((EmailConfigurationType)((EmailConfigurationType.Builder)EmailConfigurationType.builder().applyMutation(emailConfiguration)).build());
        }

        public Builder smsConfiguration(SmsConfigurationType var1);

        default public Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return this.smsConfiguration((SmsConfigurationType)((SmsConfigurationType.Builder)SmsConfigurationType.builder().applyMutation(smsConfiguration)).build());
        }

        public Builder userPoolTags(Map<String, String> var1);

        public Builder adminCreateUserConfig(AdminCreateUserConfigType var1);

        default public Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return this.adminCreateUserConfig((AdminCreateUserConfigType)((AdminCreateUserConfigType.Builder)AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

