/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobStatusType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UserImportJobTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserImportJobType
implements StructuredPojo,
ToCopyableBuilder<Builder, UserImportJobType> {
    private final String jobName;
    private final String jobId;
    private final String userPoolId;
    private final String preSignedUrl;
    private final Instant creationDate;
    private final Instant startDate;
    private final Instant completionDate;
    private final String status;
    private final String cloudWatchLogsRoleArn;
    private final Long importedUsers;
    private final Long skippedUsers;
    private final Long failedUsers;
    private final String completionMessage;

    private UserImportJobType(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.userPoolId = builder.userPoolId;
        this.preSignedUrl = builder.preSignedUrl;
        this.creationDate = builder.creationDate;
        this.startDate = builder.startDate;
        this.completionDate = builder.completionDate;
        this.status = builder.status;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.importedUsers = builder.importedUsers;
        this.skippedUsers = builder.skippedUsers;
        this.failedUsers = builder.failedUsers;
        this.completionMessage = builder.completionMessage;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobId() {
        return this.jobId;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Instant completionDate() {
        return this.completionDate;
    }

    public UserImportJobStatusType status() {
        return UserImportJobStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String cloudWatchLogsRoleArn() {
        return this.cloudWatchLogsRoleArn;
    }

    public Long importedUsers() {
        return this.importedUsers;
    }

    public Long skippedUsers() {
        return this.skippedUsers;
    }

    public Long failedUsers() {
        return this.failedUsers;
    }

    public String completionMessage() {
        return this.completionMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.skippedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserImportJobType)) {
            return false;
        }
        UserImportJobType other = (UserImportJobType)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn()) && Objects.equals(this.importedUsers(), other.importedUsers()) && Objects.equals(this.skippedUsers(), other.skippedUsers()) && Objects.equals(this.failedUsers(), other.failedUsers()) && Objects.equals(this.completionMessage(), other.completionMessage());
    }

    public String toString() {
        return ToString.builder((String)"UserImportJobType").add("JobName", (Object)this.jobName()).add("JobId", (Object)this.jobId()).add("UserPoolId", (Object)this.userPoolId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("CreationDate", (Object)this.creationDate()).add("StartDate", (Object)this.startDate()).add("CompletionDate", (Object)this.completionDate()).add("Status", (Object)this.statusAsString()).add("CloudWatchLogsRoleArn", (Object)this.cloudWatchLogsRoleArn()).add("ImportedUsers", (Object)this.importedUsers()).add("SkippedUsers", (Object)this.skippedUsers()).add("FailedUsers", (Object)this.failedUsers()).add("CompletionMessage", (Object)this.completionMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CloudWatchLogsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsRoleArn()));
            }
            case "ImportedUsers": {
                return Optional.ofNullable(clazz.cast(this.importedUsers()));
            }
            case "SkippedUsers": {
                return Optional.ofNullable(clazz.cast(this.skippedUsers()));
            }
            case "FailedUsers": {
                return Optional.ofNullable(clazz.cast(this.failedUsers()));
            }
            case "CompletionMessage": {
                return Optional.ofNullable(clazz.cast(this.completionMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserImportJobTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobId;
        private String userPoolId;
        private String preSignedUrl;
        private Instant creationDate;
        private Instant startDate;
        private Instant completionDate;
        private String status;
        private String cloudWatchLogsRoleArn;
        private Long importedUsers;
        private Long skippedUsers;
        private Long failedUsers;
        private String completionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UserImportJobType model) {
            this.jobName(model.jobName);
            this.jobId(model.jobId);
            this.userPoolId(model.userPoolId);
            this.preSignedUrl(model.preSignedUrl);
            this.creationDate(model.creationDate);
            this.startDate(model.startDate);
            this.completionDate(model.completionDate);
            this.status(model.status);
            this.cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            this.importedUsers(model.importedUsers);
            this.skippedUsers(model.skippedUsers);
            this.failedUsers(model.failedUsers);
            this.completionMessage(model.completionMessage);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserImportJobStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public final Long getImportedUsers() {
            return this.importedUsers;
        }

        @Override
        public final Builder importedUsers(Long importedUsers) {
            this.importedUsers = importedUsers;
            return this;
        }

        public final void setImportedUsers(Long importedUsers) {
            this.importedUsers = importedUsers;
        }

        public final Long getSkippedUsers() {
            return this.skippedUsers;
        }

        @Override
        public final Builder skippedUsers(Long skippedUsers) {
            this.skippedUsers = skippedUsers;
            return this;
        }

        public final void setSkippedUsers(Long skippedUsers) {
            this.skippedUsers = skippedUsers;
        }

        public final Long getFailedUsers() {
            return this.failedUsers;
        }

        @Override
        public final Builder failedUsers(Long failedUsers) {
            this.failedUsers = failedUsers;
            return this;
        }

        public final void setFailedUsers(Long failedUsers) {
            this.failedUsers = failedUsers;
        }

        public final String getCompletionMessage() {
            return this.completionMessage;
        }

        @Override
        public final Builder completionMessage(String completionMessage) {
            this.completionMessage = completionMessage;
            return this;
        }

        public final void setCompletionMessage(String completionMessage) {
            this.completionMessage = completionMessage;
        }

        public UserImportJobType build() {
            return new UserImportJobType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserImportJobType> {
        public Builder jobName(String var1);

        public Builder jobId(String var1);

        public Builder userPoolId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder creationDate(Instant var1);

        public Builder startDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder status(String var1);

        public Builder status(UserImportJobStatusType var1);

        public Builder cloudWatchLogsRoleArn(String var1);

        public Builder importedUsers(Long var1);

        public Builder skippedUsers(Long var1);

        public Builder failedUsers(Long var1);

        public Builder completionMessage(String var1);
    }
}

