/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DefaultEmailOptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerificationMessageTemplateTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerificationMessageTemplateType
implements StructuredPojo,
ToCopyableBuilder<Builder, VerificationMessageTemplateType> {
    private final String smsMessage;
    private final String emailMessage;
    private final String emailSubject;
    private final String emailMessageByLink;
    private final String emailSubjectByLink;
    private final String defaultEmailOption;

    private VerificationMessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
        this.emailMessageByLink = builder.emailMessageByLink;
        this.emailSubjectByLink = builder.emailSubjectByLink;
        this.defaultEmailOption = builder.defaultEmailOption;
    }

    public String smsMessage() {
        return this.smsMessage;
    }

    public String emailMessage() {
        return this.emailMessage;
    }

    public String emailSubject() {
        return this.emailSubject;
    }

    public String emailMessageByLink() {
        return this.emailMessageByLink;
    }

    public String emailSubjectByLink() {
        return this.emailSubjectByLink;
    }

    public DefaultEmailOptionType defaultEmailOption() {
        return DefaultEmailOptionType.fromValue(this.defaultEmailOption);
    }

    public String defaultEmailOptionAsString() {
        return this.defaultEmailOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessageByLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubjectByLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEmailOptionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationMessageTemplateType)) {
            return false;
        }
        VerificationMessageTemplateType other = (VerificationMessageTemplateType)obj;
        return Objects.equals(this.smsMessage(), other.smsMessage()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.emailSubject(), other.emailSubject()) && Objects.equals(this.emailMessageByLink(), other.emailMessageByLink()) && Objects.equals(this.emailSubjectByLink(), other.emailSubjectByLink()) && Objects.equals(this.defaultEmailOptionAsString(), other.defaultEmailOptionAsString());
    }

    public String toString() {
        return ToString.builder((String)"VerificationMessageTemplateType").add("SmsMessage", (Object)this.smsMessage()).add("EmailMessage", (Object)this.emailMessage()).add("EmailSubject", (Object)this.emailSubject()).add("EmailMessageByLink", (Object)this.emailMessageByLink()).add("EmailSubjectByLink", (Object)this.emailSubjectByLink()).add("DefaultEmailOption", (Object)this.defaultEmailOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmsMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "EmailSubject": {
                return Optional.ofNullable(clazz.cast(this.emailSubject()));
            }
            case "EmailMessageByLink": {
                return Optional.ofNullable(clazz.cast(this.emailMessageByLink()));
            }
            case "EmailSubjectByLink": {
                return Optional.ofNullable(clazz.cast(this.emailSubjectByLink()));
            }
            case "DefaultEmailOption": {
                return Optional.ofNullable(clazz.cast(this.defaultEmailOptionAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VerificationMessageTemplateTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String smsMessage;
        private String emailMessage;
        private String emailSubject;
        private String emailMessageByLink;
        private String emailSubjectByLink;
        private String defaultEmailOption;

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationMessageTemplateType model) {
            this.smsMessage(model.smsMessage);
            this.emailMessage(model.emailMessage);
            this.emailSubject(model.emailSubject);
            this.emailMessageByLink(model.emailMessageByLink);
            this.emailSubjectByLink(model.emailSubjectByLink);
            this.defaultEmailOption(model.defaultEmailOption);
        }

        public final String getSmsMessage() {
            return this.smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        public final String getEmailSubject() {
            return this.emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        public final String getEmailMessageByLink() {
            return this.emailMessageByLink;
        }

        @Override
        public final Builder emailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
            return this;
        }

        public final void setEmailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
        }

        public final String getEmailSubjectByLink() {
            return this.emailSubjectByLink;
        }

        @Override
        public final Builder emailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
            return this;
        }

        public final void setEmailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
        }

        public final String getDefaultEmailOption() {
            return this.defaultEmailOption;
        }

        @Override
        public final Builder defaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
            return this;
        }

        @Override
        public final Builder defaultEmailOption(DefaultEmailOptionType defaultEmailOption) {
            this.defaultEmailOption(defaultEmailOption.toString());
            return this;
        }

        public final void setDefaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
        }

        public VerificationMessageTemplateType build() {
            return new VerificationMessageTemplateType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VerificationMessageTemplateType> {
        public Builder smsMessage(String var1);

        public Builder emailMessage(String var1);

        public Builder emailSubject(String var1);

        public Builder emailMessageByLink(String var1);

        public Builder emailSubjectByLink(String var1);

        public Builder defaultEmailOption(String var1);

        public Builder defaultEmailOption(DefaultEmailOptionType var1);
    }
}

