/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuthenticationResultTypeMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> EXPIRESIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpiresIn").isBinary(false).build();
    private static final MarshallingInfo<String> TOKENTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenType").isBinary(false).build();
    private static final MarshallingInfo<String> REFRESHTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshToken").isBinary(false).build();
    private static final MarshallingInfo<String> IDTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdToken").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NEWDEVICEMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewDeviceMetadata").isBinary(false).build();
    private static final AuthenticationResultTypeMarshaller INSTANCE = new AuthenticationResultTypeMarshaller();

    private AuthenticationResultTypeMarshaller() {
    }

    public static AuthenticationResultTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AuthenticationResultType authenticationResultType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)authenticationResultType, (String)"authenticationResultType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)authenticationResultType.accessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall((Object)authenticationResultType.expiresIn(), EXPIRESIN_BINDING);
            protocolMarshaller.marshall((Object)authenticationResultType.tokenType(), TOKENTYPE_BINDING);
            protocolMarshaller.marshall((Object)authenticationResultType.refreshToken(), REFRESHTOKEN_BINDING);
            protocolMarshaller.marshall((Object)authenticationResultType.idToken(), IDTOKEN_BINDING);
            protocolMarshaller.marshall((Object)authenticationResultType.newDeviceMetadata(), NEWDEVICEMETADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

