/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfirmSignUpRequestModelMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretHash").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIRMATIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfirmationCode").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FORCEALIASCREATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForceAliasCreation").isBinary(false).build();
    private static final ConfirmSignUpRequestModelMarshaller INSTANCE = new ConfirmSignUpRequestModelMarshaller();

    private ConfirmSignUpRequestModelMarshaller() {
    }

    public static ConfirmSignUpRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConfirmSignUpRequest confirmSignUpRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)confirmSignUpRequest), (String)"confirmSignUpRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)confirmSignUpRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)confirmSignUpRequest.secretHash(), SECRETHASH_BINDING);
            protocolMarshaller.marshall((Object)confirmSignUpRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)confirmSignUpRequest.confirmationCode(), CONFIRMATIONCODE_BINDING);
            protocolMarshaller.marshall((Object)confirmSignUpRequest.forceAliasCreation(), FORCEALIASCREATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

