/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateUserPoolRequestModelMarshaller {
    private static final MarshallingInfo<String> POOLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PoolName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policies").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaConfig").isBinary(false).build();
    private static final MarshallingInfo<List> AUTOVERIFIEDATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoVerifiedAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> ALIASATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> USERNAMEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsernameAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> SMSVERIFICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsVerificationMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILVERIFICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailVerificationMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILVERIFICATIONSUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailVerificationSubject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VERIFICATIONMESSAGETEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VerificationMessageTemplate").isBinary(false).build();
    private static final MarshallingInfo<String> SMSAUTHENTICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsAuthenticationMessage").isBinary(false).build();
    private static final MarshallingInfo<String> MFACONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MfaConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EMAILCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SMSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Map> USERPOOLTAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolTags").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ADMINCREATEUSERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdminCreateUserConfig").isBinary(false).build();
    private static final MarshallingInfo<List> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schema").isBinary(false).build();
    private static final CreateUserPoolRequestModelMarshaller INSTANCE = new CreateUserPoolRequestModelMarshaller();

    private CreateUserPoolRequestModelMarshaller() {
    }

    public static CreateUserPoolRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateUserPoolRequest createUserPoolRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createUserPoolRequest), (String)"createUserPoolRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createUserPoolRequest.poolName(), POOLNAME_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.policies(), POLICIES_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.lambdaConfig(), LAMBDACONFIG_BINDING);
            protocolMarshaller.marshall(createUserPoolRequest.autoVerifiedAttributesAsStrings(), AUTOVERIFIEDATTRIBUTES_BINDING);
            protocolMarshaller.marshall(createUserPoolRequest.aliasAttributesAsStrings(), ALIASATTRIBUTES_BINDING);
            protocolMarshaller.marshall(createUserPoolRequest.usernameAttributesAsStrings(), USERNAMEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.smsVerificationMessage(), SMSVERIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.emailVerificationMessage(), EMAILVERIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.emailVerificationSubject(), EMAILVERIFICATIONSUBJECT_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.verificationMessageTemplate(), VERIFICATIONMESSAGETEMPLATE_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.smsAuthenticationMessage(), SMSAUTHENTICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.mfaConfigurationAsString(), MFACONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.deviceConfiguration(), DEVICECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.emailConfiguration(), EMAILCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.smsConfiguration(), SMSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createUserPoolRequest.userPoolTags(), USERPOOLTAGS_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolRequest.adminCreateUserConfig(), ADMINCREATEUSERCONFIG_BINDING);
            protocolMarshaller.marshall(createUserPoolRequest.schema(), SCHEMA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

