/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceConfigurationTypeMarshaller {
    private static final MarshallingInfo<Boolean> CHALLENGEREQUIREDONNEWDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeRequiredOnNewDevice").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DEVICEONLYREMEMBEREDONUSERPROMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceOnlyRememberedOnUserPrompt").isBinary(false).build();
    private static final DeviceConfigurationTypeMarshaller INSTANCE = new DeviceConfigurationTypeMarshaller();

    private DeviceConfigurationTypeMarshaller() {
    }

    public static DeviceConfigurationTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceConfigurationType deviceConfigurationType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceConfigurationType, (String)"deviceConfigurationType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deviceConfigurationType.challengeRequiredOnNewDevice(), CHALLENGEREQUIREDONNEWDEVICE_BINDING);
            protocolMarshaller.marshall((Object)deviceConfigurationType.deviceOnlyRememberedOnUserPrompt(), DEVICEONLYREMEMBEREDONUSERPROMPT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

